<?= $this->extend('layouts/main') ?>

<?= $this->section('title') ?>
Listado de Productos Jumpseller
<?= $this->endSection() ?>

<?= $this->section('page_title') ?>
Productos Jumpseller
<?= $this->endSection() ?>

<?= $this->section('content') ?>
<div class="techwave_fn_user_billing_page">
    <div class="container large">
        <div class="fn__title_holder">
            <h3>Productos en Jumpseller</h3>
            <div class="fn__buttons">
                <a href="<?= base_url('jumpseller') ?>" class="techwave_fn_button">
                    <span>Volver a Configuración</span>
                </a>
                <button id="refreshProductsBtn" class="techwave_fn_button">
                    <span>Actualizar Lista</span>
                </button>
                <button id="syncSelectedBtn" class="techwave_fn_button">
                    <span>Sincronizar Seleccionados</span>
                </button>
            </div>
        </div>

        <div class="fn__table_wrap">
            <table id="jumpsellerProductsTable" class="display">
                <thead>
                    <tr>
                        <th><input type="checkbox" id="select-all-js"></th>
                        <th>ID Jumpseller</th>
                        <th>Nombre</th>
                        <th>SKU</th>
                        <th>Precio</th>
                        <th>Stock JS</th>
                        <th>Stock Local</th>
                        <th>Estado</th>
                        <th>Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    <!-- Se llena vía AJAX -->
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Modal de detalles -->
<div class="modal fade" id="productDetailsModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Detalles del Producto</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body" id="productDetailsBody">
                <!-- Contenido dinámico -->
            </div>
            <div class="modal-footer">
                <button type="button" class="techwave_fn_button small" data-dismiss="modal">Cerrar</button>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
let jumpsellerProducts = [];
let localProducts = [];

function cargarProductosJumpseller() {
    Swal.fire({
        title: 'Cargando productos...',
        text: 'Obteniendo información de Jumpseller',
        allowOutsideClick: false,
        didOpen: () => {
            Swal.showLoading();
        }
    });

    $.ajax({
        url: '<?= base_url('jumpseller/listarProductosJS') ?>',
        method: 'GET',
        success: function(response) {
            if (response.success) {
                jumpsellerProducts = response.products;
                cargarProductosLocales();
            } else {
                Swal.fire({
                    title: 'Error',
                    text: response.message,
                    icon: 'error'
                });
            }
        },
        error: function() {
            Swal.fire({
                title: 'Error',
                text: 'Error al obtener productos de Jumpseller',
                icon: 'error'
            });
        }
    });
}

function cargarProductosLocales() {
    $.ajax({
        url: '<?= base_url('jumpseller/productos') ?>',
        method: 'GET',
        data: {
            start: 0,
            length: 1000, // Obtener todos los productos locales
            search: { value: '' }
        },
        success: function(response) {
            localProducts = response.data;
            mostrarProductosCombinados();
            Swal.close();
        },
        error: function() {
            Swal.fire({
                title: 'Error',
                text: 'Error al obtener productos locales',
                icon: 'error'
            });
        }
    });
}

function mostrarProductosCombinados() {
    if ($.fn.DataTable.isDataTable('#jumpsellerProductsTable')) {
        $('#jumpsellerProductsTable').DataTable().destroy();
    }

    // Combinar datos de Jumpseller con datos locales
    const combinedData = jumpsellerProducts.map(jsProduct => {
        const localProduct = localProducts.find(local => 
            local.CodProd === jsProduct.sku || local.js_id == jsProduct.id
        );
        
        return {
            ...jsProduct,
            local_stock: localProduct ? localProduct.Existen : 0,
            local_description: localProduct ? localProduct.Descrip : '',
            is_synced: !!localProduct
        };
    });

    const table = $('#jumpsellerProductsTable').DataTable({
        data: combinedData,
        columns: [
            {
                data: null,
                orderable: false,
                className: 'text-center',
                render: function(data, type, row) {
                    return `<input type="checkbox" class="product-selector" value="${row.id}" ${row.is_synced ? '' : 'disabled'}>`;
                }
            },
            { data: 'id' },
            { data: 'name' },
            { data: 'sku' },
            { 
                data: 'price',
                render: function(data) {
                    return data ? `$${parseFloat(data).toFixed(2)}` : 'N/A';
                }
            },
            { data: 'stock' },
            { 
                data: 'local_stock',
                render: function(data, type, row) {
                    if (row.is_synced) {
                        return `<span class="badge badge-success">${data}</span>`;
                    } else {
                        return `<span class="badge badge-secondary">No sincronizado</span>`;
                    }
                }
            },
            { 
                data: 'status',
                render: function(data) {
                    const statusClass = data === 'available' ? 'badge-success' : 'badge-secondary';
                    return `<span class="badge ${statusClass}">${data}</span>`;
                }
            },
            {
                data: null,
                orderable: false,
                render: function(data, type, row) {
                    return `
                        <div class="btn-group">
                            <button onclick="verDetalles(${JSON.stringify(row).replace(/"/g, '&quot;')})" 
                                    class="techwave_fn_button small">
                                <i class="lucide-eye"></i>
                            </button>
                            ${row.is_synced ? 
                                `<button onclick="sincronizarIndividual('${row.id}')" 
                                         class="techwave_fn_button small">
                                    <i class="lucide-refresh-cw"></i>
                                 </button>` : 
                                `<button onclick="agregarSincronizacion('${row.id}', '${row.sku}')" 
                                         class="techwave_fn_button small">
                                    <i class="lucide-plus"></i>
                                 </button>`
                            }
                        </div>
                    `;
                }
            }
        ],
        pageLength: 25,
        language: {
            url: 'https://cdn.datatables.net/plug-ins/1.13.7/i18n/es-ES.json'
        },
        order: [[1, 'asc']]
    });
}

function verDetalles(producto) {
    const localProduct = localProducts.find(local => 
        local.CodProd === producto.sku || local.js_id == producto.id
    );

    const detailsHtml = `
        <div class="row">
            <div class="col-md-6">
                <h5>Información Jumpseller</h5>
                <table class="table table-sm">
                    <tr><th>ID:</th><td>${producto.id}</td></tr>
                    <tr><th>Nombre:</th><td>${producto.name}</td></tr>
                    <tr><th>SKU:</th><td>${producto.sku}</td></tr>
                    <tr><th>Precio:</th><td>$${parseFloat(producto.price || 0).toFixed(2)}</td></tr>
                    <tr><th>Stock:</th><td>${producto.stock}</td></tr>
                    <tr><th>Estado:</th><td>${producto.status}</td></tr>
                    ${producto.permalink ? `<tr><th>Enlace:</th><td><a href="${producto.permalink}" target="_blank">Ver producto</a></td></tr>` : ''}
                </table>
            </div>
            <div class="col-md-6">
                <h5>Información Local</h5>
                ${localProduct ? `
                    <table class="table table-sm">
                        <tr><th>Código:</th><td>${localProduct.CodProd}</td></tr>
                        <tr><th>Descripción:</th><td>${localProduct.Descrip}</td></tr>
                        <tr><th>Stock Local:</th><td>${localProduct.Existen}</td></tr>
                        <tr><th>Precio:</th><td>$${parseFloat(localProduct.PrecioIVA || 0).toFixed(2)}</td></tr>
                        <tr><th>Última Sync:</th><td>${localProduct.ultimo_sync || 'Nunca'}</td></tr>
                    </table>
                ` : `
                    <div class="alert alert-warning">
                        <p>Este producto no está sincronizado con el inventario local.</p>
                        <p>SKU: ${producto.sku}</p>
                    </div>
                `}
            </div>
        </div>
    `;

    $('#productDetailsBody').html(detailsHtml);
    $('#productDetailsModal').modal('show');
}

function sincronizarIndividual(jsId) {
    Swal.fire({
        title: '¿Sincronizar producto?',
        text: 'Esto actualizará el stock en Jumpseller con el stock local',
        icon: 'question',
        showCancelButton: true,
        confirmButtonText: 'Sí, sincronizar',
        cancelButtonText: 'Cancelar'
    }).then((result) => {
        if (result.isConfirmed) {
            Swal.fire({
                title: 'Sincronizando...',
                allowOutsideClick: false,
                didOpen: () => Swal.showLoading()
            });

            $.ajax({
                url: '<?= base_url('jumpseller/sincronizarProducto') ?>',
                method: 'POST',
                data: { js_id: jsId },
                success: function(response) {
                    if (response.success) {
                        Swal.fire({
                            title: '¡Éxito!',
                            text: 'Producto sincronizado correctamente',
                            icon: 'success'
                        });
                        cargarProductosJumpseller(); // Recargar datos
                    } else {
                        Swal.fire({
                            title: 'Error',
                            text: response.message,
                            icon: 'error'
                        });
                    }
                },
                error: function() {
                    Swal.fire({
                        title: 'Error',
                        text: 'Error al sincronizar producto',
                        icon: 'error'
                    });
                }
            });
        }
    });
}

function agregarSincronizacion(jsId, sku) {
    Swal.fire({
        title: 'Agregar a sincronización',
        text: `¿Desea agregar el producto ${sku} a la sincronización?`,
        icon: 'question',
        showCancelButton: true,
        confirmButtonText: 'Sí, agregar',
        cancelButtonText: 'Cancelar'
    }).then((result) => {
        if (result.isConfirmed) {
            // Aquí implementarías la lógica para agregar el producto a la sincronización
            // Por ahora solo mostramos un mensaje
            Swal.fire({
                title: 'Funcionalidad en desarrollo',
                text: 'Esta funcionalidad se implementará próximamente',
                icon: 'info'
            });
        }
    });
}

document.addEventListener('DOMContentLoaded', function() {
    // Seleccionar todos
    $('#select-all-js').on('change', function() {
        const isChecked = $(this).is(':checked');
        $('.product-selector:not(:disabled)').prop('checked', isChecked);
    });

    // Botón refrescar
    $('#refreshProductsBtn').on('click', function() {
        cargarProductosJumpseller();
    });

    // Botón sincronizar seleccionados
    $('#syncSelectedBtn').on('click', function() {
        const selectedIds = $('.product-selector:checked').map(function() {
            return $(this).val();
        }).get();

        if (selectedIds.length === 0) {
            Swal.fire({
                title: 'Error',
                text: 'Debe seleccionar al menos un producto',
                icon: 'warning'
            });
            return;
        }

        Swal.fire({
            title: '¿Sincronizar productos?',
            text: `Se sincronizarán ${selectedIds.length} productos`,
            icon: 'question',
            showCancelButton: true,
            confirmButtonText: 'Sí, sincronizar',
            cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                Swal.fire({
                    title: 'Sincronizando...',
                    text: 'Por favor espere',
                    allowOutsideClick: false,
                    didOpen: () => Swal.showLoading()
                });

                $.ajax({
                    url: '<?= base_url('jumpseller/sincronizar') ?>',
                    method: 'POST',
                    data: { productos: selectedIds },
                    success: function(response) {
                        if (response.success) {
                            Swal.fire({
                                title: '¡Éxito!',
                                text: 'Productos sincronizados correctamente',
                                icon: 'success'
                            });
                            cargarProductosJumpseller(); // Recargar datos
                        } else {
                            Swal.fire({
                                title: 'Error',
                                text: response.message,
                                icon: 'error'
                            });
                        }
                    },
                    error: function() {
                        Swal.fire({
                            title: 'Error',
                            text: 'Error al sincronizar productos',
                            icon: 'error'
                        });
                    }
                });
            }
        });
    });

    // Cargar productos al inicializar
    cargarProductosJumpseller();
});
</script>
<?= $this->endSection() ?>