<?= $this->extend('layouts/main') ?>

<?= $this->section('title') ?>
Archivos - Dashboard
<?= $this->endSection() ?>

<?= $this->section('page_title') ?>
ARCHIVOS
<?= $this->endSection() ?>

<?= $this->section('content') ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Dashboard de Archivos</h4>
                </div>
                <div class="card-body">
                    <div class="row">
                        
                        <!-- Card Clientes -->
                        <div class="col-md-4 col-sm-6 mb-4">
                            <div class="info-box bg-gradient-primary">
                                <span class="info-box-icon">
                                    <i class="fas fa-users"></i>
                                </span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Clientes</span>
                                    <span class="info-box-number">
                                        <?= isset($total_clientes) ? $total_clientes : '0' ?>
                                    </span>
                                    <div class="progress">
                                        <div class="progress-bar" style="width: 100%"></div>
                                    </div>
                                    <span class="progress-description">
                                        <a href="<?= base_url('crearcliente') ?>" class="text-white">
                                            Ver todos <i class="fas fa-arrow-right"></i>
                                        </a>
                                    </span>
                                </div>
                            </div>
                        </div>

                        <!-- Card Convenios -->
                        <div class="col-md-4 col-sm-6 mb-4">
                            <div class="info-box bg-gradient-warning">
                                <span class="info-box-icon">
                                    <i class="fas fa-handshake"></i>
                                </span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Convenios</span>
                                    <span class="info-box-number">
                                        <?= isset($total_convenios) ? $total_convenios : '0' ?>
                                    </span>
                                    <div class="progress">
                                        <div class="progress-bar" style="width: 100%"></div>
                                    </div>
                                    <span class="progress-description">
                                        <a href="<?= base_url('archivos/convenios') ?>" class="text-white">
                                            Ver todos <i class="fas fa-arrow-right"></i>
                                        </a>
                                    </span>
                                </div>
                            </div>
                        </div>

                        <!-- Card Servidores -->
                        <div class="col-md-4 col-sm-6 mb-4">
                            <div class="info-box bg-gradient-success">
                                <span class="info-box-icon">
                                    <i class="fas fa-server"></i>
                                </span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Servidores</span>
                                    <span class="info-box-number">
                                        <?= isset($total_servidores) ? $total_servidores : '0' ?>
                                    </span>
                                    <div class="progress">
                                        <div class="progress-bar" style="width: 100%"></div>
                                    </div>
                                    <span class="progress-description">
                                        <a href="<?= base_url('archivos/servidores') ?>" class="text-white">
                                            Ver todos <i class="fas fa-arrow-right"></i>
                                        </a>
                                    </span>
                                </div>
                            </div>
                        </div>

                        <!-- Card Retenciones -->
                        <div class="col-md-4 col-sm-6 mb-4">
                            <div class="info-box bg-gradient-info">
                                <span class="info-box-icon">
                                    <i class="fas fa-percent"></i>
                                </span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Retenciones</span>
                                    <span class="info-box-number">
                                        <?= isset($total_retenciones) ? $total_retenciones : '1' ?>
                                    </span>
                                    <div class="progress">
                                        <div class="progress-bar" style="width: 100%"></div>
                                    </div>
                                    <span class="progress-description">
                                        <a href="<?= base_url('archivos/retenciones') ?>" class="text-white">
                                            Ver todos <i class="fas fa-arrow-right"></i>
                                        </a>
                                    </span>
                                </div>
                            </div>
                        </div>

                        <!-- Card Finalizar -->
                        <div class="col-md-4 col-sm-6 mb-4">
                            <div class="info-box bg-gradient-secondary">
                                <span class="info-box-icon">
                                    <i class="fas fa-check-circle"></i>
                                </span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Finalizar</span>
                                    <span class="info-box-number">
                                        <?= isset($total_finalizar) ? $total_finalizar : '0' ?>
                                    </span>
                                    <div class="progress">
                                        <div class="progress-bar" style="width: 100%"></div>
                                    </div>
                                    <span class="progress-description">
                                        <a href="<?= base_url('archivos/finalizar') ?>" class="text-white">
                                            Ver todos <i class="fas fa-arrow-right"></i>
                                        </a>
                                    </span>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('styles') ?>
<style>
.info-box {
    border-radius: 10px;
    box-shadow: 0 0 20px rgba(0,0,0,0.1);
    transition: all 0.3s ease;
    cursor: pointer;
}

.info-box:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(0,0,0,0.2);
}

.info-box-icon {
    font-size: 2rem;
    width: 80px;
    height: 80px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
}

.info-box-content {
    padding: 15px;
}

.info-box-text {
    color: white;
    font-weight: 600;
    font-size: 1.1rem;
}

.info-box-number {
    color: white;
    font-size: 2.5rem;
    font-weight: bold;
}

.progress {
    height: 5px;
    margin: 10px 0;
    background-color: rgba(255,255,255,0.3);
}

.progress-bar {
    background-color: rgba(255,255,255,0.5);
}

.progress-description {
    color: white;
    font-size: 0.9rem;
}

.progress-description a {
    color: white;
    text-decoration: none;
    font-weight: 500;
}

.progress-description a:hover {
    text-decoration: underline;
}
</style>
<?= $this->endSection() ?>