<?php

namespace App\Models;

use CodeIgniter\Model;

class ProductoModel extends Model
{
    protected $table = 'SAPROD';
    protected $primaryKey = 'CodProd';
    
    public function getProductos($limit = 100)
    {
        return $this->select('CodProd, Descrip, Descrip2, Precio1, CostPro')
                    ->where('Activo', 1)
                    ->limit($limit)
                    ->findAll();
    }
    
    public function getProducto($codProd)
    {
        return $this->find($codProd);
    }
    
    public function buscarProductos($term)
    {
        return $this->like('Descrip', $term)
                    ->orLike('Descrip2', $term)
                    ->orLike('CodProd', $term)
                    ->orLike('Refere', $term)
                    ->where('Activo', 1)
                    ->limit(10)
                    ->findAll();
    }
}