<?php

namespace App\Models;

use CodeIgniter\Model;

class MercadoLibreModel extends Model
{
    protected $table = 'ml_productos_sync';
    protected $primaryKey = 'id';
    //protected $allowedFields = ['cod_prod', 'ml_id', 'ultimo_sync', 'estado'];
    //protected $allowedFields = ['cod_prod', 'ml_id', 'ultimo_sync', 'estado', 'selected'];
    protected $allowedFields = [
        'cod_prod', 'ml_id', 'ultimo_sync', 'estado', 'selected',
        'ml_title', 'ml_price', 'ml_quantity', 'ml_status', 'ml_permalink'
    ];

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    public function getProductosConExistenciaPaginado($start = 0, $length = 10, $search = '', $orderColumn = 'CodProd', $orderDir = 'ASC') {
        //$mlData = $this->getMercadoLibreData();
        
        $db = \Config\Database::connect();
        $builder = $db->table('ml_productos_sync ml')
            ->select('p.Precio3, ml.cod_prod as CodProd, ml.ml_id, ml.selected, ml.estado,, ml.ultimo_sync,
                     ml.ml_title, ml.ml_price, ml.ml_quantity, ml.ml_status, ml.ml_permalink,
                     p.Descrip, p2.SINCRONIZACION,
                     SUM(e.Existen) as Existen,
                     STRING_AGG(e.CodUbic, \',\') as CodUbic,STRING_AGG(e.PuestoI, \',\') as Ubic')
            ->join('SAPROD p', 'ml.cod_prod = p.Descrip2')
            ->join('SAPROD_02 p2', 'ml.cod_prod = p2.Descrip2', 'left')
            ->join('SAEXIS e', 'p.CodProd = e.CodProd', 'left')
            ->where('p.Activo', '1')
            ->groupBy('p.Precio3, ml.cod_prod, ml.ml_id, ml.selected, ml.estado, ml.ultimo_sync, 
                      ml.ml_title, ml.ml_price, ml.ml_quantity, ml.ml_status, ml.ml_permalink,
                      p.Descrip, p2.SINCRONIZACION');
    
        // Aplicar búsqueda si existe
        if (!empty($search)) {
            $builder->groupStart()
                ->like('ml.cod_prod', $search)
                ->orLike('p.Descrip', $search)
                ->orLike('ml.ml_id', $search)
                ->groupEnd();
        }
    
        // Obtener total de registros filtrados
        $totalFiltered = $builder->countAllResults(false);
    
        // Aplicar ordenamiento y paginación
        $builder->orderBy($orderColumn, $orderDir)
                ->limit($length, $start);
    
        $results = $builder->get()->getResultArray();
        foreach ($results as &$result) {
            if (isset($result['SINCRONIZACION'])) {
                $this->where('ml_id', $result['ml_id'])
                     ->set(['selected' => $result['SINCRONIZACION']])
                     ->update();
                    
                $result['selected'] = $result['SINCRONIZACION'];
                
            }
            $precio3 = isset($result['Precio3']) ? $result['Precio3'] : 0;
            $iva = $precio3 * 0.19;
            $precioConIva = $precio3 + $iva;
            $result['PrecioIVA'] = round($precioConIva, 2);
        }
    
        // Agregar información adicional de ML
        // $processedResults = [];
        // foreach ($results as $result) {
        //     if (isset($result['SINCRONIZACION'])) {
        //         $this->where('ml_id', $result['ml_id'])  // Usando id en lugar de ml_id
        //              ->set(['selected' => $result['SINCRONIZACION']])
        //              ->update();
        //         $result['selected'] = $result['SINCRONIZACION'];
        //     }
        //     foreach ($mlData['items'] as $mlItem) {
        //         if ($mlItem['id'] === $result['ml_id']) {
        //             $result['ml_title'] = $mlItem['title'];
        //             $result['ml_price'] = $mlItem['price'];
        //             $result['ml_quantity'] = $mlItem['available_quantity'];
        //             $result['ml_status'] = $mlItem['status'];
        //             $result['ml_permalink'] = $mlItem['permalink'];
        //             $processedResults[] = $result;
        //             break;
        //         }
        //     }
        // }
    
        return [
            'data' => $results,
            'recordsFiltered' => $totalFiltered,
            'recordsTotal' => $totalFiltered
        ];
    }
    public function syncMercadoLibreData() {
        $ch = curl_init(base_url('mercadolibre/listarProductosML'));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);
        curl_close($ch);
        
        $data = json_decode($response, true);
        if (!$data['success']) {
            throw new \Exception("Error al obtener productos de MercadoLibre");
        }

        $allItems = [];
    
        foreach ($data['items'] as $item) {
            if (!empty($item['skuv'])) {
                $syncData = [
                    'cod_prod' => $item['skuv'],
                    'ml_id' => $item['id'],
                    'ultimo_sync' => date('Y-m-d H:i:s'),
                    'estado' => $item['status'] === 'active' ? 1 : 0,
                    'ml_title' => $item['title'],
                    'ml_price' => $item['price'],
                    'ml_quantity' => $item['available_quantity'],
                    'ml_status' => $item['status'],
                    'ml_permalink' => $item['permalink']
                ];
    
                $existing = $this->where('ml_id', $item['id'])->first();
                
                if (!$existing) {
                    $this->insert($syncData);
                } else {
                    $this->update($existing['id'], $syncData);
                }
            }
            else {

                $allItems[] = [$item];


            }
        }
    
        return $allItems;
    }
    private function getMercadoLibreData() {
        $ch = curl_init(base_url('mercadolibre/listarProductosML'));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);
        curl_close($ch);
        
        $data = json_decode($response, true);
        if (!$data['success']) {
            throw new \Exception("Error al obtener productos de MercadoLibre");
        }
    
        // Sincronizar publicaciones
        foreach ($data['items'] as $item) {
            if (!empty($item['skuv'])) {
                $existing = $this->where('ml_id', $item['id'])->first();
                
                $syncData = [
                    'cod_prod' => $item['skuv'],
                    'ml_id' => $item['id'],
                    'ultimo_sync' => date('Y-m-d H:i:s'),
                    'estado' => $item['status'] === 'active' ? 1 : 0
                ];
    
                if (!$existing) {
                    $this->insert($syncData);
                } else {
                    $this->update($existing['id'], $syncData);
                }
            }
        }
    
        return $data;
    }
    public function toggleSelected($mlId, $selected) {
        return $this->where('ml_id', $mlId)
                   ->set(['selected' => $selected])
                   ->update();
    }

    public function getProductosSincronizados()
    {
        $db = \Config\Database::connect();
        return $db->table('ml_productos_sync m')
                 ->select('m.*, p.Descrip, e.Existen')
                 ->join('SAPROD p', 'm.cod_prod = p.CodProd')
                 ->join('SAEXIS e', 'p.CodProd = e.CodProd')
                 ->where('m.estado', 1)
                 ->get()
                 ->getResultArray();
    }

    public function registrarSincronizacion($codProd, $mlId, $estado = 1)
    {
        $data = [
            'cod_prod' => $codProd,
            'ml_id' => $mlId,
            'ultimo_sync' => date('Y-m-d H:i:s'),
            'estado' => $estado
        ];

        $existing = $this->where('cod_prod', $codProd)->first();
        
        if ($existing) {
            return $this->update($existing['id'], $data);
        }
        
        return $this->insert($data);
    }
}
    // public function getProductosConExistenciaPaginado($start = 0, $length = 10, $search = '', $orderColumn = 'CodProd', $orderDir = 'ASC') {
    //     $mlData = $this->getMercadoLibreData();
        
    //     $db = \Config\Database::connect();
    //     $builder = $db->table('SAPROD p')
    //         ->select('p.CodProd, p.Descrip, SUM(e.Existen) as Existen, 
    //                  STRING_AGG(e.CodUbic, \',\') as CodUbic, 
    //                  ml.ml_id, ml.selected, ml.estado')
    //         ->join('SAEXIS e', 'p.CodProd = e.CodProd', 'left')
    //         ->join('ml_productos_sync ml', 'p.CodProd = ml.cod_prod', 'left')
    //         ->where('p.Activo', '1')
    //         ->groupBy('p.CodProd, p.Descrip, ml.ml_id, ml.selected, ml.estado');

    //     // Aplicar filtros y búsqueda
    //     if (!empty($search)) {
    //         $builder->groupStart()
    //             ->like('p.CodProd', $search)
    //             ->orLike('p.Descrip', $search)
    //             ->groupEnd();
    //     }

    //     $totalFiltered = $builder->countAllResults(false);
    //     $results = $builder->orderBy($orderColumn, $orderDir)
    //         ->limit($length, $start)
    //         ->get()
    //         ->getResultArray();

    //     // Agregar datos de ML para cada publicación
    //     $processedResults = [];
    //     foreach ($results as $result) {
    //         foreach ($mlData['items'] as $mlItem) {
    //             if ($mlItem['skuv'] === $result['CodProd']) {
    //                 $newResult = $result;
    //                 $newResult['ml_id'] = $mlItem['id'];
    //                 $newResult['ml_title'] = $mlItem['title'];
    //                 $newResult['ml_price'] = $mlItem['price'];
    //                 $newResult['ml_status'] = $mlItem['status'];
    //                 $newResult['ml_permalink'] = $mlItem['permalink'];
    //                 $processedResults[] = $newResult;
    //             }
    //         }
    //     }

    //     return [
    //         'data' => $processedResults,
    //         'recordsFiltered' => $totalFiltered,
    //         'recordsTotal' => count($processedResults)
    //     ];
    // }
    

    // private function getMercadoLibreData() {
    //     $ch = curl_init(base_url('mercadolibre/listarProductosML'));
    //     curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    //     $response = curl_exec($ch);
    //     curl_close($ch);
        
    //     $data = json_decode($response, true);
    //     if (!$data['success']) {
    //         throw new \Exception("Error al obtener productos de MercadoLibre");
    //     }
    //     return $data;
    // }

    
    
