<?= $this->extend('layouts/main') ?>

<?= $this->section('title') ?>
Detalle de Orden MercadoLibre #<?= $orden['order_id'] ?>
<?= $this->endSection() ?>

<?= $this->section('page_title') ?>
Detalle de Orden MercadoLibre
<?= $this->endSection() ?>

<?= $this->section('content') ?>
<div class="techwave_fn_user_billing_page">
    <div class="container small">
        <div class="fn__title_holder">
            <h3>Orden #<?= $orden['order_id'] ?></h3>
            <div class="fn__buttons">
                <a href="<?= base_url('mercadolibre_orders') ?>" class="techwave_fn_button">
                    <span>Volver al Listado</span>
                </a>
                <?php if ($orden['processed'] != 1): ?>
                <button id="btnCrearFactura" class="techwave_fn_button" data-order-id="<?= $orden['order_id'] ?>">
                    <span>Crear Factura</span>
                </button>
                <?php else: ?>
                <div class="alert alert-success mt-3">
                    <p>Factura generada: <?= $orden['invoice_id'] ?></p>
                </div>
                <?php endif; ?>
            </div>
        </div>
        
        <div class="row">
            <div class="col-md-6">
                <div class="card mb-4">
                    <div class="card-header">
                        <h4>Información General</h4>
                    </div>
                    <div class="card-body">
                        <table class="table table-striped">
                            <tr>
                                <th>ID Orden:</th>
                                <td><?= $orden['order_id'] ?></td>
                            </tr>
                            <tr>
                                <th>Fecha de Creación:</th>
                                <td><?= date('d/m/Y H:i', strtotime($orden['date_created'])) ?></td>
                            </tr>
                            <tr>
                                <th>Estado:</th>
                                <td>
                                    <span class="badge <?= $orden['status'] == 'paid' ? 'badge-success' : 'badge-secondary' ?>">
                                        <?= $orden['status'] == 'paid' ? 'Pagado' : $orden['status'] ?>
                                    </span>
                                </td>
                            </tr>
                            <tr>
                                <th>Total:</th>
                                <td><?= number_format($orden['total_amount'], 2) ?> <?= $orden['currency_id'] ?></td>
                            </tr>
                            <tr>
                                <th>Método de Pago:</th>
                                <td><?= $orden['payment_method'] ?></td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="card mb-4">
                    <div class="card-header">
                        <h4>Información del Comprador</h4>
                    </div>
                    <div class="card-body">
                        <table class="table table-striped">
                            <tr>
                                <th>ID Comprador:</th>
                                <td><?= $orden['buyer_id'] ?></td>
                            </tr>
                            <tr>
                                <th>Nombre:</th>
                                <td><?= $orden['buyer_nickname'] ?></td>
                            </tr>
                            <?php if (isset($ordenJson['buyer']['first_name'])): ?>
                            <tr>
                                <th>Nombre Completo:</th>
                                <td><?= $ordenJson['buyer']['first_name'] ?> <?= $ordenJson['buyer']['last_name'] ?></td>
                            </tr>
                            <?php endif; ?>
                            <?php if (isset($ordenJson['buyer']['email'])): ?>
                            <tr>
                                <th>Email:</th>
                                <td><?= $ordenJson['buyer']['email'] ?></td>
                            </tr>
                            <?php endif; ?>
                            <?php if (isset($ordenJson['buyer']['phone'])): ?>
                            <tr>
                                <th>Teléfono:</th>
                                <td>
                                    <?= $ordenJson['buyer']['phone']['area_code'] ?? '' ?> 
                                    <?= $ordenJson['buyer']['phone']['number'] ?? '' ?>
                                </td>
                            </tr>
                            <?php endif; ?>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="card mb-4">
            <div class="card-header">
                <h4>Productos</h4>
            </div>
            <div class="card-body">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Título</th>
                            <th>SKU</th>
                            <th>Cantidad</th>
                            <th>Precio Unitario</th>
                            <th>Subtotal</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($ordenJson['order_items'] as $item): ?>
                        <tr>
                            <td><?= $item['item']['id'] ?></td>
                            <td><?= $item['item']['title'] ?></td>
                            <td>
                                <?php 
                                $sku = '';
                                if (isset($item['item']['seller_custom_field'])) {
                                    $sku = $item['item']['seller_custom_field'];
                                } elseif (isset($item['item']['seller_sku'])) {
                                    $sku = $item['item']['seller_sku'];
                                }
                                echo $sku;
                                ?>
                            </td>
                            <td><?= $item['quantity'] ?></td>
                            <td><?= number_format($item['unit_price'], 2) ?> <?= $orden['currency_id'] ?></td>
                            <td><?= number_format($item['unit_price'] * $item['quantity'], 2) ?> <?= $orden['currency_id'] ?></td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                    <tfoot>
                        <tr>
                            <th colspan="5" class="text-right">Total:</th>
                            <th><?= number_format($orden['total_amount'], 2) ?> <?= $orden['currency_id'] ?></th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
        
        <?php if (isset($ordenJson['shipping'])): ?>
        <div class="card mb-4">
            <div class="card-header">
                <h4>Información de Envío</h4>
            </div>
            <div class="card-body">
                <table class="table table-striped">
                    <tr>
                        <th>ID Envío:</th>
                        <td><?= $ordenJson['shipping']['id'] ?></td>
                    </tr>
                    <tr>
                        <th>Estado:</th>
                        <td><?= var_dump($ordenJson['shipping']) ?></td>
                    </tr>
                    <?php if (isset($ordenJson['shipping']['receiver_address'])): ?>
                    <tr>
                        <th>Dirección:</th>
                        <td>
                            <?= $ordenJson['shipping']['receiver_address']['street_name'] ?? '' ?>
                            <?= $ordenJson['shipping']['receiver_address']['street_number'] ?? '' ?>,
                            <?= $ordenJson['shipping']['receiver_address']['city']['name'] ?? '' ?>,
                            <?= $ordenJson['shipping']['receiver_address']['state']['name'] ?? '' ?>,
                            <?= $ordenJson['shipping']['receiver_address']['country']['name'] ?? '' ?>
                        </td>
                    </tr>
                    <?php endif; ?>
                </table>
            </div>
        </div>
        <?php endif; ?>
        
        <?php if (isset($ordenJson['payments']) && !empty($ordenJson['payments'])): ?>
        <div class="card mb-4">
            <div class="card-header">
                <h4>Información de Pago</h4>
            </div>
            <div class="card-body">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>ID Pago</th>
                            <th>Método</th>
                            <th>Estado</th>
                            <th>Monto</th>
                            <th>Fecha</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($ordenJson['payments'] as $payment): ?>
                        <tr>
                            <td><?= $payment['id'] ?></td>
                            <td><?= $payment['payment_method_id'] ?></td>
                            <td><?= $payment['status'] ?></td>
                            <td><?= number_format($payment['total_paid_amount'], 2) ?> <?= $payment['currency_id'] ?></td>
                            <td><?= date('d/m/Y H:i', strtotime($payment['date_created'])) ?></td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <?php endif; ?>
        
        <?php if ($orden['processed'] != 1): ?>
        <div class="text-center mb-4">
            <button id="btnCrearFacturaBottom" class="techwave_fn_button" data-order-id="<?= $orden['order_id'] ?>">
                <span>Crear Factura</span>
            </button>
        </div>
        <?php endif; ?>
    </div>
</div>

<!-- Modal de estado -->
<div class="modal fade" id="statusModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Estado</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body" id="statusModalBody">
                <!-- Contenido dinámico -->
            </div>
            <div class="modal-footer">
                <button type="button" class="techwave_fn_button small" data-dismiss="modal">Cerrar</button>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Botón de crear factura (ambos botones, arriba y abajo)
    $('#btnCrearFactura, #btnCrearFacturaBottom').on('click', function() {
        const btn = $(this);
        const orderId = btn.data('order-id');
        
        $('#btnCrearFactura, #btnCrearFacturaBottom').prop('disabled', true);
        $('#btnCrearFactura, #btnCrearFacturaBottom').html('<span><i class="fas fa-spinner fa-spin"></i> Procesando...</span>');
        
        $.ajax({
            url: '<?= base_url('mercadolibre_orders/crearFactura') ?>',
            method: 'POST',
            data: {
                order_id: orderId
            },
            success: function(response) {
                if (response.success) {
                    $('#statusModalBody').html(`
                        <div class="alert alert-success">
                            <p>${response.message}</p>
                            <p>Factura generada: ${response.invoice_id}</p>
                        </div>
                    `);
                    
                    // Recargar la página para mostrar el cambio
                    setTimeout(function() {
                        location.reload();
                    }, 2000);
                } else {
                    $('#statusModalBody').html(`
                        <div class="alert alert-danger">
                            <p>${response.message}</p>
                        </div>
                    `);
                    
                    $('#btnCrearFactura, #btnCrearFacturaBottom').prop('disabled', false);
                    $('#btnCrearFactura, #btnCrearFacturaBottom').html('<span>Crear Factura</span>');
                }
                
                $('#statusModal').modal('show');
            },
            error: function(xhr) {
                $('#statusModalBody').html(`
                    <div class="alert alert-danger">
                        <p>Error al crear la factura</p>
                    </div>
                `);
                
                $('#statusModal').modal('show');
                $('#btnCrearFactura, #btnCrearFacturaBottom').prop('disabled', false);
                $('#btnCrearFactura, #btnCrearFacturaBottom').html('<span>Crear Factura</span>');
            }
        });
    });
});
</script>
<?= $this->endSection() ?>