<?= $this->extend('layouts/main') ?>

<?= $this->section('title') ?>Gestión de Compras<?= $this->endSection() ?>

<?= $this->section('page_title') ?>Procesar Factura de Compra (XML DTE)<?= $this->endSection() ?>

<?= $this->section('content') ?>
<style>
.info-section {
    margin-bottom: 30px;
    padding: 20px;
    border: 1px solid #e0e0e0;
    border-radius: 12px;
    background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
    box-shadow: 0 2px 8px rgba(0,0,0,0.1);
}

.info-section h4 {
    margin-bottom: 20px;
    color: #495057;
    border-bottom: 2px solid #007bff;
    padding-bottom: 10px;
    font-weight: 600;
}

.form-row {
    display: flex;
    flex-wrap: wrap;
    margin: -10px;
}

.form-col {
    padding: 10px;
    min-width: 200px;
}

.form-col-3 { flex: 0 0 25%; }
.form-col-4 { flex: 0 0 33.333333%; }
.form-col-6 { flex: 0 0 50%; }
.form-col-8 { flex: 0 0 66.666667%; }
.form-col-12 { flex: 0 0 100%; }

.form-label {
    display: block;
    margin-bottom: 5px;
    font-weight: 500;
    color: #495057;
}

.form-control {
    width: 100%;
    padding: 10px 12px;
    border: 1px solid #ced4da;
    border-radius: 6px;
    font-size: 14px;
    transition: all 0.3s ease;
}

.form-control:focus {
    outline: none;
    border-color: #007bff;
    box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25);
}

.form-control:read-only {
    background-color: #e9ecef;
    opacity: 1;
}

.table-container {
    overflow-x: auto;
    margin-top: 20px;
    border-radius: 8px;
    box-shadow: 0 2px 8px rgba(0,0,0,0.1);
}

.details-table {
    width: 100%;
    border-collapse: collapse;
    background: white;
    border-radius: 8px;
    overflow: hidden;
    min-width: 800px;
}

.details-table th {
    background: linear-gradient(135deg, #007bff 0%, #0056b3 100%);
    color: white;
    padding: 12px 8px;
    text-align: left;
    font-weight: 600;
    font-size: 13px;
    border: none;
}

.details-table td {
    padding: 10px 8px;
    border-bottom: 1px solid #e9ecef;
    font-size: 13px;
    vertical-align: middle;
}

.details-table tbody tr:hover {
    background-color: #f8f9fa;
}

.details-table tbody tr:last-child td {
    border-bottom: none;
}

.btn-edit {
    background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
    color: white;
    border: none;
    padding: 6px 12px;
    border-radius: 6px;
    cursor: pointer;
    font-size: 12px;
    font-weight: 500;
    transition: all 0.3s ease;
}

.btn-edit:hover {
    transform: translateY(-1px);
    box-shadow: 0 4px 8px rgba(40, 167, 69, 0.3);
}

.action-buttons {
    margin-top: 30px;
    padding: 20px;
    text-align: center;
    background: #f8f9fa;
    border-radius: 8px;
}

.loading-spinner {
    display: none;
    text-align: center;
    padding: 20px;
}

.spinner {
    border: 4px solid #f3f3f3;
    border-top: 4px solid #007bff;
    border-radius: 50%;
    width: 40px;
    height: 40px;
    animation: spin 1s linear infinite;
    margin: 0 auto;
}

@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

@media (max-width: 768px) {
    .form-col-3, .form-col-4, .form-col-6, .form-col-8 {
        flex: 0 0 100%;
    }
    
    .details-table {
        font-size: 12px;
    }
    
    .details-table th, .details-table td {
        padding: 8px 4px;
    }
}
</style>

<div class="techwave_fn_models_page">
    <div class="container">
        <!-- Panel de carga de XML -->
        <div class="techwave_fn_feed" id="panelCarga">
            <div class="item">
                <div class="item__content">
                    <div class="item__header">
                        <h3>Cargar Archivo XML DTE</h3>
                        <p>Seleccione el archivo XML del DTE de la factura de compra para procesarlo automáticamente</p>
                    </div>
                    
                    <div class="item__form">
                        <form id="formPrevisualizarXML" enctype="multipart/form-data">
                            <div class="techwave_fn_interactive_list">
                                <div class="item">
                                    <label for="xml_file">Archivo XML DTE</label>
                                    <input type="file" 
                                           id="xml_file" 
                                           name="xml_file" 
                                           accept=".xml" 
                                           required
                                           class="techwave_fn_input">
                                    <span class="input_description">Formatos soportados: XML</span>
                                </div>
                            </div>
                            
                            <div class="techwave_fn_interactive_list">
                                <div class="item">
                                    <button type="submit" 
                                            class="techwave_fn_button" 
                                            id="btnPrevisualizar">
                                        <span>Previsualizar XML</span>
                                    </button>
                                    <a href="<?= base_url('compras/listado') ?>" 
                                       class="techwave_fn_button secondary">
                                        <span>Ver Compras</span>
                                    </a>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <!-- Loading spinner -->
        <div class="loading-spinner" id="loadingSpinner">
            <div class="spinner"></div>
            <p>Procesando archivo XML...</p>
        </div>
        
        <!-- Panel de previsualización -->
        <div class="techwave_fn_feed" id="panelPreview" style="display: none;">
            <div class="item">
                <div class="item__content">
                    <div class="item__header">
                        <h3>Previsualización y Edición del XML</h3>
                        <p>Revise y modifique la información antes de procesar la compra</p>
                    </div>
                    
                    <div class="item__form">
                        <!-- Información del Proveedor -->
                        <div class="info-section">
                            <h4>📦 Información del Proveedor</h4>
                            <div class="form-row">
                                <div class="form-col form-col-3">
                                    <label class="form-label">RUT</label>
                                    <input type="text" id="emisor_rut" class="form-control" readonly>
                                </div>
                                <div class="form-col form-col-6">
                                    <label class="form-label">Razón Social</label>
                                    <input type="text" id="emisor_razonSocial" class="form-control">
                                </div>
                                <div class="form-col form-col-3">
                                    <label class="form-label">Ciudad</label>
                                    <input type="text" id="emisor_ciudad" class="form-control">
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="form-col form-col-12">
                                    <label class="form-label">Dirección</label>
                                    <input type="text" id="emisor_direccion" class="form-control">
                                </div>
                            </div>
                        </div>
                        
                        <!-- Información del Documento -->
                        <div class="info-section">
                            <h4>📄 Información del Documento</h4>
                            <div class="form-row">
                                <div class="form-col form-col-3">
                                    <label class="form-label">Tipo DTE</label>
                                    <input type="text" id="doc_tipo" class="form-control" readonly>
                                </div>
                                <div class="form-col form-col-3">
                                    <label class="form-label">Folio</label>
                                    <input type="text" id="doc_folio" class="form-control" readonly>
                                </div>
                                <div class="form-col form-col-3">
                                    <label class="form-label">Fecha Emisión</label>
                                    <input type="date" id="doc_fechaEmision" class="form-control">
                                </div>
                                <div class="form-col form-col-3">
                                    <label class="form-label">Fecha Vencimiento</label>
                                    <input type="date" id="doc_fechaVencimiento" class="form-control">
                                </div>
                            </div>
                        </div>
                        
                        <!-- Totales -->
                        <div class="info-section">
                            <h4>💰 Totales del Documento</h4>
                            <div class="form-row">
                                <div class="form-col form-col-4">
                                    <label class="form-label">Monto Neto</label>
                                    <input type="number" id="totales_neto" class="form-control" step="0.01" readonly>
                                </div>
                                <div class="form-col form-col-4">
                                    <label class="form-label">IVA (19%)</label>
                                    <input type="number" id="totales_iva" class="form-control" step="0.01" readonly>
                                </div>
                                <div class="form-col form-col-4">
                                    <label class="form-label">Total</label>
                                    <input type="number" id="totales_total" class="form-control" step="0.01" readonly>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Detalles -->
                        <div class="info-section">
                            <h4>📋 Detalles de la Factura</h4>
                            <div class="table-container">
                                <table class="details-table">
                                    <thead>
                                        <tr>
                                            <th style="width: 40px;">#</th>
                                            <th style="width: 100px;">Código</th>
                                            <th style="min-width: 200px;">Descripción</th>
                                            <th style="width: 80px;">Cant.</th>
                                            <th style="width: 100px;">Precio Unit.</th>
                                            <th style="width: 100px;">Total</th>
                                            <th style="width: 80px;">Lote</th>
                                            <th style="width: 100px;">Vencimiento</th>
                                            <th style="width: 80px;">Acción</th>
                                        </tr>
                                    </thead>
                                    <tbody id="cuerpoTablaDetalles">
                                        <!-- Los detalles se cargan aquí dinámicamente -->
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        
                        <!-- Botones de acción -->
                        <div class="action-buttons">
                            <button type="button" 
                                    class="techwave_fn_button" 
                                    id="btnProcesarFinal">
                                <span>✅ Procesar Compra</span>
                            </button>
                            <button type="button" 
                                    class="techwave_fn_button secondary" 
                                    id="btnCancelar">
                                <span>❌ Cancelar</span>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
let datosXML = null;
let xmlContent = null;

jQuery(document).ready(function($) {
    
    // Validación de archivo XML al seleccionar
    $('#xml_file').on('change', function() {
        var file = this.files[0];
        if (file) {
            if (file.type !== 'text/xml' && !file.name.endsWith('.xml')) {
                Swal.fire({
                    icon: 'warning',
                    title: 'Formato no válido',
                    text: 'Por favor seleccione un archivo XML válido',
                    confirmButtonColor: '#007bff'
                });
                $(this).val('');
                return;
            }
            
            if (file.size > 5 * 1024 * 1024) { // 5MB
                Swal.fire({
                    icon: 'warning',
                    title: 'Archivo muy grande',
                    text: 'El archivo no puede ser mayor a 5MB',
                    confirmButtonColor: '#007bff'
                });
                $(this).val('');
                return;
            }
            
            // Mostrar información del archivo
            const fileInfo = `
                <strong>Archivo seleccionado:</strong><br>
                📁 ${file.name}<br>
                📊 ${(file.size / 1024).toFixed(2)} KB<br>
                📅 ${new Date(file.lastModified).toLocaleString('es-CL')}
            `;
            
            Swal.fire({
                icon: 'info',
                title: 'Archivo cargado',
                html: fileInfo,
                timer: 2000,
                showConfirmButton: false
            });
        }
    });
    
    // Previsualizar XML
    $('#formPrevisualizarXML').on('submit', function(e) {
        e.preventDefault();
        
        var formData = new FormData(this);
        var btnPrevisualizar = $('#btnPrevisualizar');
        
        if (!$('#xml_file').val()) {
            Swal.fire({
                icon: 'warning',
                title: 'Archivo requerido',
                text: 'Por favor seleccione un archivo XML',
                confirmButtonColor: '#007bff'
            });
            return;
        }
        
        btnPrevisualizar.prop('disabled', true).html('<span>Procesando...</span>');
        $('#loadingSpinner').show();
        
        $.ajax({
            url: '<?= base_url('compras/previsualizarXML') ?>',
            method: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    console.log(response.datos);
                    //console.log(response.datos);
                    datosXML = response.datos;
                    xmlContent = response.xml_content;
                    mostrarPreview(datosXML);
                    $('#panelCarga').hide();
                    $('#panelPreview').fadeIn();
                    
                    Swal.fire({
                        icon: 'success',
                        title: 'XML cargado correctamente',
                        text: 'Revise los datos antes de procesar',
                        timer: 2000,
                        showConfirmButton: false
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error al procesar XML',
                        text: response.message,
                        confirmButtonColor: '#dc3545'
                    });
                }
            },
            error: function(xhr, status, error) {
                console.error('Error:', error);
                Swal.fire({
                    icon: 'error',
                    title: 'Error de conexión',
                    text: 'Ocurrió un error al procesar el archivo XML',
                    confirmButtonColor: '#dc3545'
                });
            },
            complete: function() {
                btnPrevisualizar.prop('disabled', false).html('<span>Previsualizar XML</span>');
                $('#loadingSpinner').hide();
            }
        });
    });
    
    // Procesar compra final
    $('#btnProcesarFinal').on('click', function() {
        if (!datosXML || !xmlContent) {
            Swal.fire({
                icon: 'error',
                title: 'Datos faltantes',
                text: 'No hay datos para procesar',
                confirmButtonColor: '#dc3545'
            });
            return;
        }
        
        Swal.fire({
            title: '¿Procesar compra?',
            text: 'Se creará la compra con los datos actuales. ¿Continuar?',
            icon: 'question',
            showCancelButton: true,
            confirmButtonColor: '#28a745',
            cancelButtonColor: '#6c757d',
            confirmButtonText: 'Sí, procesar',
            cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                procesarCompraFinal();
            }
        });
    });
    
    // Cancelar y volver al panel de carga
    $('#btnCancelar').on('click', function() {
        Swal.fire({
            title: '¿Cancelar proceso?',
            text: 'Se perderán todos los cambios realizados',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#dc3545',
            cancelButtonColor: '#6c757d',
            confirmButtonText: 'Sí, cancelar',
            cancelButtonText: 'Continuar editando'
        }).then((result) => {
            if (result.isConfirmed) {
                $('#panelPreview').hide();
                $('#panelCarga').show();
                $('#xml_file').val('');
                datosXML = null;
                xmlContent = null;
                
                Swal.fire({
                    icon: 'info',
                    title: 'Proceso cancelado',
                    timer: 1500,
                    showConfirmButton: false
                });
            }
        });
    });
});

function procesarCompraFinal() {
    var datosModificados = recopilarDatos();
    var btnProcesar = $('#btnProcesarFinal');
    
    btnProcesar.prop('disabled', true).html('<span>Procesando...</span>');
    
    // Mostrar loading
    Swal.fire({
        title: 'Procesando compra...',
        text: 'Por favor espere mientras se guarda la información',
        icon: 'info',
        allowOutsideClick: false,
        showConfirmButton: false,
        didOpen: () => {
            Swal.showLoading();
        }
    });
    
    $.ajax({
        url: '<?= base_url('compras/procesarXMLModificado') ?>',
        method: 'POST',
        data: {
            xml_content: xmlContent,
            datos: datosModificados
        },
        dataType: 'json',
        success: function(response) {
            console.log(response);
            if (response.success) {
                Swal.fire({
                    icon: 'success',
                    title: '¡Compra procesada!',
                    html: `
                        <p><strong>Número de compra:</strong> ${response.compra_id}</p>
                        <p>La factura se ha procesado correctamente</p>
                    `,
                    showCancelButton: true,
                    confirmButtonColor: '#007bff',
                    cancelButtonColor: '#28a745',
                    confirmButtonText: 'Ver compra',
                    cancelButtonText: 'Nueva compra'
                }).then((result) => {
                    if (result.isConfirmed) {
                        window.location.href = '<?= base_url('compras/ver') ?>/' + response.compra_id;
                    } else {
                        location.reload();
                    }
                });
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Error al procesar',
                    text: response.message,
                    confirmButtonColor: '#dc3545'
                });
            }
        },
        error: function(xhr, status, error) {
            console.error('Error:', error);
            Swal.fire({
                icon: 'error',
                title: 'Error de conexión',
                text: 'Ocurrió un error al procesar la compra. Intente nuevamente.',
                confirmButtonColor: '#dc3545'
            });
        },
        complete: function() {
            btnProcesar.prop('disabled', false).html('<span>✅ Procesar Compra</span>');
        }
    });
}

function mostrarPreview(datos) {
    // Llenar información del emisor
    $('#emisor_rut').val(datos.emisor.rut);
    $('#emisor_razonSocial').val(datos.emisor.razonSocial);
    $('#emisor_direccion').val(datos.emisor.direccion);
    $('#emisor_ciudad').val(datos.emisor.ciudad);
    
    // Llenar información del documento
    $('#doc_tipo').val(datos.documento.tipo);
    $('#doc_folio').val(datos.documento.folio);
    $('#doc_fechaEmision').val(datos.documento.fechaEmision);
    $('#doc_fechaVencimiento').val(datos.documento.fechaVencimiento);
    
    // Llenar totales
    $('#totales_neto').val(datos.totales.neto.toFixed(2));
    $('#totales_iva').val(datos.totales.iva.toFixed(2));
    $('#totales_total').val(datos.totales.total.toFixed(2));
    
    // Llenar tabla de detalles
    actualizarTablaDetalles();
}

function actualizarTablaDetalles() {
    var cuerpo = $('#cuerpoTablaDetalles');
    cuerpo.empty();
    
    datosXML.detalles.forEach(function(detalle, index) {
        // Validación costo vs precio
        let alertaCosto = '';
        if (detalle.precioUnitario > detalle.CostAct) {
            alertaCosto = `<div style="color:red; font-size:12px; font-weight:bold;">⚠️ Incremento en el costo</div>`;
        }

        // Validación de CodProd
        let codProdExtra = '';
        //if (detalle.CodProd) {
            codProdExtra = `<div style="font-size:12px; color:#555;">${detalle.CodProd}</div>`;
            if (detalle.CodProd == '') {
                codProdExtra += `<div style="color:red; font-size:12px; font-weight:bold;">Crear producto</div>`;
            }
        //}
        var fila = `
            <tr>
                <td>${detalle.nroLinea}</td>
                <td title="${detalle.codigoItem}">${truncateText(detalle.codigoItem, 12)}${codProdExtra}</td>
                <td title="${detalle.descripcion}">${truncateText(detalle.descripcion, 30)}</td>
                <td>${detalle.cantidad}</td>
                <td>
                    $${formatNumber(detalle.CostAct)}
                    <div style="font-size:12px; color:#555;">Costo: $${formatNumber(detalle.precioUnitario || 0)}</div>
                    ${alertaCosto}
                </td>
                <td><strong>$${formatNumber(detalle.montoItem)}</strong></td>
                <td>${detalle.lote && detalle.lote.trim() !== '' ? detalle.lote : '-'}</td>
                <td>${detalle.fechaVencimiento}</td>
                <td>
                    <button class="btn-edit" onclick="editarDetalle(${index})">
                        ✏️ Editar
                    </button>
                </td>
            </tr>
        `;
        cuerpo.append(fila);
    });
}

function editarDetalle(indice) {
    var detalle = datosXML.detalles[indice];
    
    Swal.fire({
        title: `Editar Línea ${detalle.nroLinea}`,
        html: `
            <div style="text-align: left;">
                <div style="margin-bottom: 15px;">
                    <label style="display: block; margin-bottom: 5px; font-weight: bold;">Código del Producto:</label>
                    <input type="text" id="swal_codigo" class="swal2-input" value="${detalle.codigoItem}" style="margin: 0; width: 100%;">
                </div>

                <div style="margin-bottom: 15px;">
                    <label style="display: block; margin-bottom: 5px; font-weight: bold;">CodProd SAINT:</label>
                    <input type="text" id="swal_codprod" class="swal2-input" value="${detalle.CodProd}" style="margin: 0; width: 100%; disabled">
                </div>
                
                <div style="margin-bottom: 15px;">
                    <label style="display: block; margin-bottom: 5px; font-weight: bold;">Descripción:</label>
                    <input type="text" id="swal_descripcion" class="swal2-input" value="${detalle.descripcion}" style="margin: 0; width: 100%;">
                </div>
                
                <div style="display: flex; gap: 10px; margin-bottom: 15px;">
                    <div style="flex: 1;">
                        <label style="display: block; margin-bottom: 5px; font-weight: bold;">Cantidad:</label>
                        <input type="number" id="swal_cantidad" class="swal2-input" value="${detalle.cantidad}" step="0.01" style="margin: 0; width: 100%;">
                    </div>
                    <div style="flex: 1;">
                        <label style="display: block; margin-bottom: 5px; font-weight: bold;">Precio Unit.:</label>
                        <input type="number" id="swal_precio" class="swal2-input" value="${detalle.precioUnitario}" step="0.01" style="margin: 0; width: 100%;">
                    </div>
                    <div style="flex: 1;">
                        <label style="display: block; margin-bottom: 5px; font-weight: bold;">Costo.:</label>
                        <input type="number" id="swal_costo" class="swal2-input" value="${detalle.CostAct}" step="0.01" style="margin: 0; width: 100%;" disabled>
                    </div>
                </div>
                
                <div style="display: flex; gap: 10px; margin-bottom: 15px;">
                    <div style="flex: 1;">
                        <label style="display: block; margin-bottom: 5px; font-weight: bold;">Código de Barras:</label>
                        <input type="text" id="swal_codigoBarras" class="swal2-input" value="${detalle.codigoBarras || ''}" style="margin: 0; width: 100%;">
                    </div>
                    <div style="flex: 1;">
                        <label style="display: block; margin-bottom: 5px; font-weight: bold;">Lote:</label>
                        <input type="text" id="swal_lote" class="swal2-input" value="${detalle.lote || ''}" style="margin: 0; width: 100%;">
                    </div>
                </div>
                
                <div style="margin-bottom: 15px;">
                    <label style="display: block; margin-bottom: 5px; font-weight: bold;">Fecha Vencimiento:</label>
                    <input type="date" id="swal_fechaVencimiento" class="swal2-input" value="${detalle.fechaVencimiento || ''}" style="margin: 0; width: 100%;">
                </div>
                
                <div style="margin-bottom: 15px; padding: 10px; background-color: #f8f9fa; border-radius: 5px;">
                    <label style="display: block; margin-bottom: 5px; font-weight: bold;">Total Calculado:</label>
                    <span id="total_calculado" style="font-size: 18px; font-weight: bold; color: #007bff;">$${formatNumber(detalle.montoItem)}</span>
                </div>
            </div>
        `,
        width: '600px',
        showCancelButton: true,
        confirmButtonText: '💾 Guardar',
        cancelButtonText: '❌ Cancelar',
        confirmButtonColor: '#28a745',
        cancelButtonColor: '#6c757d',
        didOpen: () => {
            // Calcular total automáticamente
            function calcularTotal() {
                const cantidad = parseFloat(document.getElementById('swal_cantidad').value) || 0;
                const precio = parseFloat(document.getElementById('swal_precio').value) || 0;
                const total = cantidad * precio;
                document.getElementById('total_calculado').textContent = '$' + formatNumber(total);
            }
            
            document.getElementById('swal_cantidad').addEventListener('input', calcularTotal);
            document.getElementById('swal_precio').addEventListener('input', calcularTotal);
        },
        preConfirm: () => {
            const codigo = document.getElementById('swal_codigo').value;
            const codprod = document.getElementById('swal_codprod').value;
            const descripcion = document.getElementById('swal_descripcion').value;
            const cantidad = parseFloat(document.getElementById('swal_cantidad').value);
            const precio = parseFloat(document.getElementById('swal_precio').value);
            const costo = parseFloat(document.getElementById('swal_costo').value);
            
            if (!codigo || !descripcion || !cantidad || !precio) {
                Swal.showValidationMessage('Por favor complete todos los campos requeridos');
                return false;
            }
            
            if (cantidad <= 0 || precio <= 0) {
                Swal.showValidationMessage('Cantidad y precio deben ser mayores a cero');
                return false;
            }
            
            return {
                codigo: codigo,
                codprod:codprod,
                costo:costo,
                descripcion: descripcion,
                cantidad: cantidad,
                precio: precio,
                codigoBarras: document.getElementById('swal_codigoBarras').value,
                lote: document.getElementById('swal_lote').value,
                fechaVencimiento: document.getElementById('swal_fechaVencimiento').value
            };
        }
    }).then((result) => {
        if (result.isConfirmed) {
            const datos = result.value;
            
            // Actualizar datos
            datosXML.detalles[indice] = {
                nroLinea: datosXML.detalles[indice].nroLinea,
                codigoItem: datos.codigo,
                CodProd: datos.codprod,
                CostAct: datos.costo,
                descripcion: datos.descripcion,
                cantidad: datos.cantidad,
                precioUnitario: datos.precio,
                montoItem: datos.cantidad * datos.precio,
                codigoBarras: datos.codigoBarras,
                lote: datos.lote,
                fechaVencimiento: datos.fechaVencimiento
            };
            
            // Actualizar tabla y totales
            actualizarTablaDetalles();
            recalcularTotales();
            
            Swal.fire({
                icon: 'success',
                title: 'Detalle actualizado',
                text: 'Los cambios se han guardado correctamente',
                timer: 1500,
                showConfirmButton: false
            });
        }
    });
}

function recopilarDatos() {
    return {
        emisor: {
            rut: $('#emisor_rut').val(),
            razonSocial: $('#emisor_razonSocial').val(),
            direccion: $('#emisor_direccion').val(),
            ciudad: $('#emisor_ciudad').val()
        },
        documento: {
            tipo: $('#doc_tipo').val(),
            folio: $('#doc_folio').val(),
            fechaEmision: $('#doc_fechaEmision').val(),
            fechaVencimiento: $('#doc_fechaVencimiento').val()
        },
        totales: {
            neto: parseFloat($('#totales_neto').val()),
            iva: parseFloat($('#totales_iva').val()),
            total: parseFloat($('#totales_total').val())
        },
        detalles: datosXML.detalles
    };
}

function recalcularTotales() {
    var neto = 0;
    
    datosXML.detalles.forEach(function(detalle) {
        neto += detalle.montoItem;
    });
    
    var iva = neto * 0.19;
    var total = neto + iva;
    
    $('#totales_neto').val(neto.toFixed(2));
    $('#totales_iva').val(iva.toFixed(2));
    $('#totales_total').val(total.toFixed(2));
    
    // Actualizar también en los datos
    datosXML.totales.neto = neto;
    datosXML.totales.iva = iva;
    datosXML.totales.total = total;
}

function formatNumber(num) {
    return parseFloat(num).toLocaleString('es-CL', {
        minimumFractionDigits: 0,
        maximumFractionDigits: 2
    });
}

function formatDate(dateString) {
    if (!dateString) return '-';
    const date = new Date(dateString);
    return date.toLocaleDateString('es-CL');
}

function truncateText(text, maxLength) {
    if (!text) return '-';
    if (text.length <= maxLength) return text;
    return text.substring(0, maxLength) + '...';
}
</script>
<?= $this->endSection() ?>