<?php

namespace App\Models;

use CodeIgniter\Model;

class JumpsellerModel extends Model
{
    protected $table = 'js_productos_sync';
    protected $primaryKey = 'id';
    protected $allowedFields = [
        'cod_prod', 'js_id', 'ultimo_sync', 'estado', 'selected',
        'js_name', 'js_price', 'js_stock', 'js_status', 'js_permalink'
    ];

    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    public function getProductosConExistenciaPaginado($start = 0, $length = 10, $search = '', $orderColumn = 'CodProd', $orderDir = 'ASC')
    {
        $db = \Config\Database::connect();
        $builder = $db->table('js_productos_sync js')
            ->select('p.Precio3, js.cod_prod as CodProd, js.js_id, js.selected, js.estado, js.ultimo_sync,
                     js.js_name, js.js_price, js.js_stock, js.js_status, js.js_permalink,
                     p.Descrip, p2.SINCRONIZACION,
                     SUM(e.Existen) as Existen,
                     STRING_AGG(e.CodUbic, \',\') as CodUbic, STRING_AGG(e.PuestoI, \',\') as Ubic')
            ->join('SAPROD p', 'js.cod_prod = p.Descrip2')
            ->join('SAPROD_02 p2', 'js.cod_prod = p2.Descrip2', 'left')
            ->join('SAEXIS e', 'p.CodProd = e.CodProd', 'left')
            ->where('p.Activo', '1')
            ->groupBy('p.Precio3, js.cod_prod, js.js_id, js.selected, js.estado, js.ultimo_sync, 
                      js.js_name, js.js_price, js.js_stock, js.js_status, js.js_permalink,
                      p.Descrip, p2.SINCRONIZACION');

        // Aplicar búsqueda si existe
        if (!empty($search)) {
            $builder->groupStart()
                ->like('js.cod_prod', $search)
                ->orLike('p.Descrip', $search)
                ->orLike('js.js_id', $search)
                ->groupEnd();
        }

        // Obtener total de registros filtrados
        $totalFiltered = $builder->countAllResults(false);

        // Aplicar ordenamiento y paginación
        $builder->orderBy($orderColumn, $orderDir)
                ->limit($length, $start);

        $results = $builder->get()->getResultArray();
        
        foreach ($results as &$result) {
            if (isset($result['SINCRONIZACION'])) {
                $this->where('js_id', $result['js_id'])
                     ->set(['selected' => $result['SINCRONIZACION']])
                     ->update();
                    
                $result['selected'] = $result['SINCRONIZACION'];
            }
            
            // Calcular precio con IVA
            $precio3 = isset($result['Precio3']) ? $result['Precio3'] : 0;
            $iva = $precio3 * 0.19;
            $precioConIva = $precio3 + $iva;
            $result['PrecioIVA'] = round($precioConIva, 2);
        }

        return [
            'data' => $results,
            'recordsFiltered' => $totalFiltered,
            'recordsTotal' => $totalFiltered
        ];
    }

    public function syncJumpsellerData($allProducts)
    {
        //$ch = curl_init(base_url('jumpseller/listarProductosJS'));
        //curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        //$response = curl_exec($ch);
        //curl_close($ch);
        
        //$data = json_decode($response, true);
        //if (!$data['success']) {
        //    throw new \Exception("Error al obtener productos de Jumpseller");
        //}

        $allItems = [];        

        foreach ($allProducts as $product) {
            if (!empty($product['sku'])) {
                $syncData = [
                    'cod_prod' => $product['sku'],
                    'js_id' => $product['id'],
                    'ultimo_sync' => date('Y-m-d H:i:s'),
                    'estado' => $product['status'] === 'available' ? 1 : 0,
                    'js_name' => $product['name'],
                    //'js_price' => $product['price'],
                    'js_stock' => $product['stock'],
                    'js_status' => $product['status'],
                    //'js_permalink' => $product['permalink']
                ];

                $existing = $this->where('js_id', $product['id'])->first();
                
                if (!$existing) {
                    $this->insert($syncData);
                } else {
                    $this->update($existing['id'], $syncData);
                }
            } else {
                $allItems[] = $product;
            }
            
        }

        return $allItems;
    }

    public function toggleSelected($jsId, $selected)
    {
        return $this->where('js_id', $jsId)
                   ->set(['selected' => $selected])
                   ->update();
    }

    public function getProductosSincronizados()
    {
        $db = \Config\Database::connect();
        return $db->table('js_productos_sync j')
                 ->select('j.*, p.Descrip, e.Existen')
                 ->join('SAPROD p', 'j.cod_prod = p.CodProd')
                 ->join('SAEXIS e', 'p.CodProd = e.CodProd')
                 ->where('j.estado', 1)
                 ->get()
                 ->getResultArray();
    }

    public function registrarSincronizacion($codProd, $jsId, $estado = 1, $js_stock)
    {
        $data = [
            'cod_prod' => $codProd,
            'js_id' => $jsId,
            'ultimo_sync' => date('Y-m-d H:i:s'),
            'estado' => $estado,
            'js_stock' => $js_stock
        ];

        $existing = $this->where('cod_prod', $codProd)->first();
        
        if ($existing) {
            return $this->update($existing['id'], $data);
        }
        
        return $this->insert($data);
    }
}