<?php

namespace App\Controllers;

use Config\Services;

class Compras extends BaseController
{
    protected $db;
    protected $productoModel;
    protected $proveedorModel;
    

    public function __construct()
    {
        $this->db = \Config\Database::connect();
        // Comprobar si el usuario está logueado
        // if (!session()->get('isLoggedIn')) {
        //     echo view('login');
        //     exit;
        // }
        
        // Cargar los modelos necesarios
        $this->productoModel = new \App\Models\ProductoModel();
        //$this->proveedorModel = new \App\Models\ProveedorModel();
    }

    public function index()
    {
        $data = [
            'proveedores' => [],
        ];
        
        return view('compras/index', $data);
    }
    /**
     * Previsualizar archivo XML sin procesarlo
     */
    public function previsualizarXML()
    {
        if ($this->request->isAJAX()) {
            try {
                $file = $this->request->getFile('xml_file');
                
                if (!$file->isValid()) {
                    throw new \Exception('Archivo XML no válido');
                }
                
                // Leer el contenido del archivo XML
                $xmlContent = file_get_contents($file->getTempName());
                $xml = simplexml_load_string($xmlContent);
                
                if (!$xml) {
                    throw new \Exception('No se pudo procesar el archivo XML');
                }
                
                // Extraer información del DTE
                $datosXML = $this->extraerDatosXML($xml);

                $dte = $xml->SetDTE->DTE->Documento;
                $encabezado = $dte->Encabezado;
                
                // Información del emisor
                $emisor = $encabezado->Emisor;
                
                // Información del documento
                $idDoc = $encabezado->IdDoc;
                
                // Totales
                $totales = $encabezado->Totales;
                
                // Procesar detalles
                $detalles = [];
                $detallesXML = $dte->Detalle;

                $detallesXML = [$detallesXML];
                
                return $this->response->setJSON([
                    'success' => true,
                    'datos' => $datosXML,
                    'detalles' => $detallesXML,
                    'xml_content' => base64_encode($xmlContent) // Para enviar después
                ]);
                
            } catch (\Exception $e) {
                return $this->response->setJSON([
                    'success' => false,
                    'message' => $e->getMessage()
                ]);
            }
        }
    }
    /**
     * Extraer datos del XML para previsualización
     */
    private function extraerDatosXML($xml)
    {
        $dte = $xml->SetDTE->DTE->Documento;
        $encabezado = $dte->Encabezado;
        
        // Información del emisor
        $emisor = $encabezado->Emisor;
        
        // Información del documento
        $idDoc = $encabezado->IdDoc;
        
        // Totales
        $totales = $encabezado->Totales;
        
        // Procesar detalles
        $detalles = [];
        $detallesXML = $dte->Detalle;
        
        // Si hay un solo detalle, convertirlo a array
        // if (!is_array($detallesXML)) {
        //     $detallesXML = [$detallesXML];
        // }

        //if (!isset($detallesXML[0])) {
        //    $detallesXML = [$detallesXML];
        //}
        
        foreach ($detallesXML as $detalle) {
            $codigoItem = '';
            $codigoBarras = '';
            $lote = '';
            
            // Buscar códigos en CdgItem
            //if (isset($detalle->CdgItem)) {
                // $codigos = is_array($detalle->CdgItem) ? $detalle->CdgItem : [$detalle->CdgItem];

            $codigos = $detalle->CdgItem;
            
            
            foreach ($codigos as $codigo) {
                $tipoCodigo = (string)$codigo->TpoCodigo;
                $valorCodigo = (string)$codigo->VlrCodigo;
                
                switch ($tipoCodigo) {
                    case 'INT1':
                        $codigoItem = $valorCodigo;
                        break;
                    case 'EAN13':
                        $codigoBarras = $valorCodigo;
                        break;
                    case 'LOTE':
                        $lote = $valorCodigo;
                        break;
                }
            }
            //}
            
            if (empty($codigoItem)) {
                $codigoItem = (string)$detalle->NmbItem;
            }

            $producto = $this->db->table('SAPROD')
                ->where('Refere', $codigoBarras)
                ->get()
                ->getRowArray();
            $codProd = "";

            $cosProd = 0;
            
            if (!$producto) {                
                $codProd = '';
                $cosProd = (float)$detalle->PrcItem;
            }
            else{
                $codProd = $producto['CodProd'];
                $cosProd = (float)$producto['CostAct'];
            }
            
            $detalles[] = [
                'nroLinea' => (int)$detalle->NroLinDet,
                'codigoItem' => $codigoItem,
                'CodProd' => $codProd,
                'CostAct' => $cosProd,
                'descripcion' => (string)$producto['Descrip'],
                'cantidad' => (int)$detalle->QtyItem,
                'precioUnitario' => (float)$detalle->PrcItem,
                'montoItem' => (float)$detalle->MontoItem,
                'codigos' => $codigos,
                'codigosreal' => $detalle->CdgItem,
                'detallesXML' => $detallesXML,
                'codigoBarras' => $codigoBarras,
                'lote' => $lote,
                'fechaVencimiento' => isset($detalle->FchVencim) ? (string)$detalle->FchVencim : ''
            ];
        }
        
        return [
            'emisor' => [
                //'rut' => str_replace('-', '', (string)$emisor->RUTEmisor),
                'rut' => (string)$emisor->RUTEmisor,
                'razonSocial' => (string)$emisor->RznSoc,
                'giro' => (string)$emisor->GiroEmis,
                'direccion' => (string)$emisor->DirOrigen,
                'ciudad' => (string)$emisor->CiudadOrigen
            ],
            'documento' => [
                'tipo' => (string)$idDoc->TipoDTE,
                'folio' => (string)$idDoc->Folio,
                'fechaEmision' => (string)$idDoc->FchEmis,
                'fechaVencimiento' => isset($idDoc->FchVenc) ? (string)$idDoc->FchVenc : ''
            ],
            'totales' => [
                'neto' => (float)$totales->MntNeto,
                'iva' => (float)$totales->IVA,
                'total' => (float)$totales->MntTotal
            ],
            'detalles' => $detalles
        ];
    }

    /**
     * Procesar XML con datos modificados
     */
    public function procesarXMLModificado()
    {
        if ($this->request->isAJAX()) {
            try {
                $xmlContent = base64_decode($this->request->getPost('xml_content'));
                $datosModificados = $this->request->getPost('datos');
                
                if (!$xmlContent || !$datosModificados) {
                    throw new \Exception('Datos incompletos');
                }
                
                // Procesar con los datos modificados
                $resultado = $this->procesarDTEModificado($xmlContent, $datosModificados);
                
                return $this->response->setJSON([
                    'success' => true,
                    'message' => 'Compra procesada correctamente',
                    'compra_id' => $resultado['numeroD']
                ]);
                
            } catch (\Exception $e) {
                return $this->response->setJSON([
                    'success' => false,
                    'message' => $e->getMessage()
                ]);
            }
        }
    }
    /**
     * Procesar DTE con datos modificados
     */
    private function procesarDTEModificado($xmlContent, $datosModificados)
    {
        try {
            // Iniciar transacción
            $this->db->transStart();
            
            // Obtener el correlativo para la compra
            // $correlativo = $this->obtenerCorrelativo('PrxComp');
            // if (!$correlativo) {
            //     throw new \Exception('Error al obtener el correlativo para la compra');
            // }

            $compra = $this->db->table('SACOMP')
                ->where('NumeroD', $datosModificados['documento']['folio'])
                ->get()
                ->getRowArray();

            if ($compra) {
                # code...
                throw new \Exception('El numero de folio #' . $datosModificados['documento']['folio'] . 'ya se ha creado anteriormente');
            }
            
            // Buscar o crear proveedor usando datos modificados
            $codProveedor = $this->obtenerOCrearProveedorModificado($datosModificados['emisor']);


            // Convertir fechas al formato correcto para SQL Server datetime
            //$fechaEmision = date('Y-m-d H:i:s', strtotime($datosModificados['documento']['fechaEmision']));
            //$fechaVenc = date('Y-m-d H:i:s', strtotime($datosModificados['documento']['fechaVencimiento']));
            
            // Verificar que las fechas se crearon correctamente
            // if ($fechaEmision) {
            //     var_dump($fechaEmision);
            //     throw new \Exception('Error al procesar la fecha de emisión: ' . $datosModificados['documento']['fechaEmision']);
            // }
            // if (!$fechaVenc) {
            //     throw new \Exception('Error al procesar la fecha de vencimiento: ' . $datosModificados['documento']['fechaVencimiento']);
            // }

            $fechaObj = \DateTime::createFromFormat('Y-m-d', $datosModificados['documento']['fechaEmision']);
            // if ($fechaObj) {
            //     return $fechaObj->format('m-d-Y H:i');
            // }

            $fechaObj2 = \DateTime::createFromFormat('Y-m-d', $datosModificados['documento']['fechaVencimiento']);
            // if ($fechaObj2) {
            //     return $fechaObj2->format('m-d-Y H:i');
            // }

            log_message('error', 'Fecha emisión original: ' . $datosModificados['documento']['fechaEmision']);
            log_message('error', 'Fecha emisión1 formateada: ' .date('Y-d-m H:i:s'));
            log_message('error', 'Fecha emisión2 formateada: ' . $fechaObj->format('Y-d-m H:i:s'));
            log_message('error', 'Fecha vencimiento original: ' . $datosModificados['documento']['fechaVencimiento']);
            log_message('error', 'Fecha vencimiento formateada: ' . $fechaObj2->format('Y-d-m H:i:s'));

            
            // Crear el registro en SACOMP usando datos modificados
            $compraData = [
                'CodSucu' => '00000',
                'TipoCom' => 'J',
                'NumeroD' => $datosModificados['documento']['folio'],
                'CodProv' => $codProveedor,
                // 'NroUnico' => $datosModificados['documento']['folio'],
                'CodUsua' => '01',
                //'Signo' => 1,
                'FechaT' => date('Y-d-m H:i:s'),
                'FechaE' => $fechaObj->format('Y-d-m H:i:s'),
                'FechaV' => $fechaObj2->format('Y-d-m H:i:s'),
                //'Moneda' => 'CLP',
                'Factor' => 1,
                //'TipoTra' => 'N',
                'CodUbic' => '01',
                'Descrip' => $datosModificados['emisor']['razonSocial'],
                'Direc1' => $datosModificados['emisor']['direccion'],
                // 'Ciudad' => $datosModificados['emisor']['ciudad'],
                'Monto' => $datosModificados['totales']['neto'],
                'MtoTax' => $datosModificados['totales']['iva'],
                'TGravable' => $datosModificados['totales']['neto'],
                'TExento' => 0,
                'MtoTotal' => $datosModificados['totales']['total'],
                'Contado' => $datosModificados['totales']['total'],
                //'Credito' => 0,
                //'SaldoAct' => 0,
                //'FechaR' => date('Y-m-d H:i:s'),
                //'FechaI' => date('Y-m-d H:i:s'),
                //'FechaP' => date('Y-m-d H:i:s'),
                'Notas1' => 'Importado desde XML DTE (Modificado)'
            ];

            //log_message('error', 'Fecha emisión2 formateada: ' . str($compraData));
            log_message('error', 'CompraData: ' . print_r($compraData, true));
            // log_message('error', 'Fecha emisión2 formateada: ' . substr($fechaObj->format('Y-m-d H:i:s.v'), 0, 23));
            
            // Insertar en SACOMP
            //var_dump($compraData['FechaE'], new \DateTime($compraData['FechaE']));
            $this->db->table('SACOMP')->insert($compraData);

            log_message('error', 'pasa sacom');


            
            
            // Procesar los detalles modificados
            $this->procesarDetallesModificados($datosModificados['detalles'], $compraData);
            
            // Confirmar transacción
            $this->db->transComplete();
            
            if ($this->db->transStatus() === false) {
                $error = $this->db->error();
                $dbError = "Error de BD - Código: " . $error['code'] . " | Mensaje: " . $error['message'];
                throw new \Exception('Error en la transacción de la base de datos: ' . $dbError);
            }
            
            return [
                'numeroD' => $datosModificados['documento']['folio'],
                'proveedor' => $datosModificados['emisor']['razonSocial'],
                'total' => $datosModificados['totales']['total']
            ];
            
        } catch (\Exception $e) {
            $this->db->transRollback();
            throw $e;
        }
    }

    /**
     * Procesar detalles modificados
     */
    private function procesarDetallesModificados($detalles, $compraData)
    {
        $nroLinea = 1;

        log_message('error', 'entra a detalles');

        
        
        foreach ($detalles as $detalle) {
            // Buscar o crear el producto
            $this->obtenerOCrearProductoModificado($detalle);

            $fechaObj3 = \DateTime::createFromFormat('Y-m-d', $detalle['fechaVencimiento']);
            
            // Crear el registro en SAITEMCOM
            $itemCompraData = [
                'CodSucu' => $compraData['CodSucu'],
                'TipoCom' => $compraData['TipoCom'],
                'NumeroD' => $compraData['NumeroD'],
                'CodProv' => $compraData['CodProv'],
                //'Status' => $compraData['Status'],
                'NroLinea' => $nroLinea,
                'CodItem' => $detalle['CodProd'],
                'CodUbic' => $compraData['CodUbic'],
                'Descrip1' => $detalle['descripcion'],
                'Refere' => $detalle['codigoBarras'],
                'Signo' => 1,
                'Cantidad' => $detalle['cantidad'],
                'CantidadO' => $detalle['cantidad'],
                'ExistAnt' => $this->obtenerExistenciaAnterior($detalle['CodProd'], $compraData['CodUbic']),
                'CantidadU' => $detalle['cantidad'],
                'Costo' => $detalle['precioUnitario'],
                'TotalItem' => $detalle['montoItem'],
                //'Precio' => $detalle['precioUnitario'],
                'NroLote' => $detalle['lote'],
                'FechaE' => date('Y-d-m H:i:s'),
                'FechaV' => $fechaObj3->format('Y-d-m H:i:s'),
                'EsServ' => 0,
                'EsUnid' => 1,
                'EsPesa' => 0,
                'EsExento' => 0,
                'DEsLote' => !empty($detalle['lote']) ? 1 : 0,
                'MtoTax' => 0
            ];
            
            // Insertar en SAITEMCOM
            $this->db->table('SAITEMCOM')->insert($itemCompraData);
            
            // Actualizar inventario
            $this->actualizarInventario($detalle['CodProd'], $compraData['CodUbic'], 
                                    $detalle['cantidad'], $detalle['precioUnitario']);
            
            // // Crear registro de lote si existe
            if (!empty($detalle['lote'])) {
                $this->crearRegistroLote($detalle['CodProd'], $compraData, $detalle['lote'], 
                                    $detalle['cantidad'], $detalle['precioUnitario'], $fechaObj3->format('Y-d-m H:i:s'));
            }
            
            $nroLinea++;
        }
    }

    /**
     * Obtener o crear proveedor con datos modificados
     */
    private function obtenerOCrearProveedorModificado($emisorData)
    {
        // Buscar proveedor existente por RUT
        $proveedor = $this->db->table('SAPROV')
            ->where('ID3', $emisorData['rut'])
            ->get()
            ->getRowArray();
        
        if ($proveedor) {
            return $proveedor['CodProv'];
        }
        
        // Crear nuevo proveedor
        // $correlativoProv = $this->obtenerCorrelativo('PrxProv');
        // if (!$correlativoProv) {
        //     throw new \Exception('Error al obtener correlativo para proveedor');
        // }
        
        // $proveedorData = [
        //     'CodProv' => 'P' . str_pad($correlativoProv['NumeroD'], 6, '0', STR_PAD_LEFT),
        //     'Descrip' => $emisorData['razonSocial'],
        //     'Direc1' => $emisorData['direccion'],
        //     'Ciudad' => $emisorData['ciudad'],
        //     'ID3' => $emisorData['rut'],
        //     'Activo' => 1,
        //     'EsProvee' => 1
        // ];
        
        // $this->db->table('SAPROV')->insert($proveedorData);
        
        // return $proveedorData['CodProv'];
    }

    /**
     * Obtener o crear producto con datos modificados
     */
    private function obtenerOCrearProductoModificado($detalleData)
    {
        // Buscar producto existente
        $producto = $this->db->table('SAPROD')
            ->where('Refere', $detalleData['codigoBarras'])
            ->get()
            ->getRowArray();
        
        if ($producto) {
            return $detalleData['CodProd'];
        }
        
        // Crear nuevo producto
        // $productoData = [
        //     'CodProd' => $detalleData['codigoItem'],
        //     'Descrip' => $detalleData['descripcion'],
        //     'Activo' => 1,
        //     'Refere' => $detalleData['codigoBarras'],
        //     'Unidad' => 'UND',
        //     'CantEmpaq' => 1,
        //     'Precio1' => $detalleData['precioUnitario'] * 1.3,
        //     'CostAct' => $detalleData['precioUnitario'],
        //     'CostPro' => $detalleData['precioUnitario'],
        //     'Existen' => 0,
        //     'EsImport' => 1,
        //     'ExDecimal' => 0,
        //     'DEsLote' => !empty($detalleData['lote']) ? 1 : 0,
        //     'DEsVence' => !empty($detalleData['fechaVencimiento']) ? 1 : 0
        // ];
        
        // $this->db->table('SAPROD')->insert($productoData);
        
        // return $detalleData['codigoItem'];
    }
    /**
     * Procesar archivo XML DTE
     */
    public function procesarXML()
    {
        if ($this->request->isAJAX()) {
            try {
                $file = $this->request->getFile('xml_file');
                
                if (!$file->isValid()) {
                    throw new \Exception('Archivo XML no válido');
                }
                
                // Leer el contenido del archivo XML
                $xmlContent = file_get_contents($file->getTempName());
                $xml = simplexml_load_string($xmlContent);
                
                if (!$xml) {
                    throw new \Exception('No se pudo procesar el archivo XML');
                }
                
                // Procesar el DTE
                $resultado = $this->procesarDTE($xml);
                
                return $this->response->setJSON([
                    'success' => true,
                    'message' => 'Compra procesada correctamente',
                    'compra_id' => $resultado['numeroD']
                ]);
                
            } catch (\Exception $e) {
                return $this->response->setJSON([
                    'success' => false,
                    'message' => $e->getMessage()
                ]);
            }
        }
    }
    
    /**
     * Procesar el documento DTE y extraer la información
     */
    private function procesarDTE($xml)
    {
        try {

            
            // Iniciar transacción
            $this->db->transStart();
            
            // Navegar al documento dentro del XML
            $dte = $xml->SetDTE->DTE->Documento;
            $encabezado = $dte->Encabezado;
            
            // Extraer información del emisor (proveedor)
            $emisor = $encabezado->Emisor;
            $rutProveedor = str_replace('-', '', (string)$emisor->RUTEmisor);
            
            // Extraer información del documento
            $idDoc = $encabezado->IdDoc;
            $folio = (string)$idDoc->Folio;
            $fechaEmision = (string)$idDoc->FchEmis;
            $fechaVencimiento = isset($idDoc->FchVenc) ? (string)$idDoc->FchVenc : null;
            
            // Extraer totales
            $totales = $encabezado->Totales;
            $montoNeto = (float)$totales->MntNeto;
            $iva = (float)$totales->IVA;
            $montoTotal = (float)$totales->MntTotal;

            $compra = $this->db->table('SACOMP')
                ->where('NumeroD', $folio)
                ->get()
                ->getRowArray();

            if ($compra) {
                # code...
                throw new \Exception('El numero de folio #' . $folio . 'ya se ha creado anteriormente');
            }
            
            // Obtener el correlativo para la compra
            // $correlativo = $this->obtenerCorrelativo('PrxComp');
            // if (!$correlativo) {
            //     throw new \Exception('Error al obtener el correlativo para la compra');
            // }
            
            // Buscar o crear proveedor
            $codProveedor = $this->obtenerOCrearProveedor($emisor, $rutProveedor);
            
            // Crear el registro en SACOMP
            $compraData = [
                'CodSucu' => '00000',
                'TipoCom' => 'J', // Factura de compra
                'NumeroD' => $folio,
                'CodProv' => $codProveedor,
                // 'NroUnico' => $folio,
                //'Status' => 'A', // Activa
                'NroCtrol' => $folio,
                'CodUsua' => '01',
                'Signo' => 1,
                'FechaT' => date('m-d-Y H:i'),
                'FechaE' => $fechaEmision,
                'FechaV' => $fechaVencimiento,
                //'Moneda' => 'CLP',
                'Factor' => 1,
                //'TipoTra' => 'N', // Normal
                'CodUbic' => '01', // Bodega principal
                'Descrip' => (string)$emisor->RznSoc,
                'Direc1' => (string)$emisor->DirOrigen,
                // 'Ciudad' => (string)$emisor->CiudadOrigen,
                'Monto' => $montoNeto,
                'MtoTax' => $iva,
                'TGravable' => $montoNeto,
                'TExento' => 0,
                'MtoTotal' => $montoTotal,
                'Contado' => $montoTotal,
                //'Credito' => 0,
                //'SaldoAct' => 0,
                'FechaR' => date('m-d-Y H:i'),
                'Notas1' => 'Importado desde XML DTE'
            ];
            
            // Insertar en SACOMP
            $this->db->table('SACOMP')->insert($compraData);
            
            // Procesar los detalles
            $this->procesarDetallesCompra($dte->Detalle, $compraData);
            
            // Confirmar transacción
            $this->db->transComplete();
            
            if ($this->db->transStatus() === false) {
                $error = $this->db->error();
                $dbError = "Error de BD - Código: " . $error['code'] . " | Mensaje: " . $error['message'];
                throw new \Exception('Error en la transacción de la base de datos: ' . $dbError);
            }
            
            return [
                'numeroD' => $folio,
                'proveedor' => (string)$emisor->RznSoc,
                'total' => $montoTotal
            ];
            
        } catch (\Exception $e) {
            $this->db->transRollback();
            throw $e;
        }
    }
    
    /**
     * Procesar los detalles de la compra
     */
    private function procesarDetallesCompra($detalles, $compraData)
    {
        $nroLinea = 1;
        
        // Si hay un solo detalle, convertirlo a array
        if (!is_array($detalles)) {
            $detalles = [$detalles];
        }
        
        foreach ($detalles as $detalle) {
            // Extraer información del producto
            $codigoItem = '';
            $codigoBarras = '';
            $lote = '';
            
            // Buscar códigos en CdgItem
            if (isset($detalle->CdgItem)) {
                // $codigos = is_array($detalle->CdgItem) ? $detalle->CdgItem : [$detalle->CdgItem];

                $codigos = $detalle->CdgItem;
                
                foreach ($codigos as $codigo) {
                    switch ((string)$codigo->TpoCodigo) {
                        case 'INT1':
                            $codigoItem = (string)$codigo->VlrCodigo;
                            break;
                        case 'EAN13':
                            $codigoBarras = (string)$codigo->VlrCodigo;
                            break;
                        case 'LOTE':
                            $lote = trim((string)$codigo->VlrCodigo);
                            break;
                    }
                }
            }

            $producto = $this->db->table('SAPROD')
                ->where('Refere', $codigoBarras)
                ->get()
                ->getRowArray();
            $codProd = "";

            $cosProd = 0;
            
            if (!$producto) {                
                $codProd = '';
                $cosProd = (float)$detalle->PrcItem;
            }
            else{
                $codProd = $producto['CodProd'];
                $cosProd = (float)$producto['CostAct'];
            }
            
            // Si no hay código interno, usar el NmbItem
            //if (empty($codigoItem)) {
            //    $codigoItem = (string)$detalle->NmbItem;
            //}
            
            $cantidad = (int)$detalle->QtyItem;
            $precioUnitario = (float)$detalle->PrcItem;
            $montoItem = (float)$detalle->MontoItem;
            $fechaVencimiento = isset($detalle->FchVencim) ? (string)$detalle->FchVencim : null;
            
            // Buscar o crear el producto
            $this->obtenerOCrearProducto($codigoItem, $detalle, $codigoBarras);
            
            // Crear el registro en SAITEMCOM
            $itemCompraData = [
                'CodSucu' => $compraData['CodSucu'],
                'TipoCom' => $compraData['TipoCom'],
                'NumeroD' => $compraData['NumeroD'],
                'CodProv' => $compraData['CodProv'],
                //'Status' => $compraData['Status'],
                'NroLinea' => $nroLinea,
                'CodItem' => $codProd,
                'CodUbic' => $compraData['CodUbic'],
                'Descrip1' => (string)$producto['Descrip'],
                'Refere' => $codigoBarras,
                'Signo' => 1,
                'Cantidad' => $cantidad,
                'CantidadO' => $cantidad,
                'ExistAnt' => $this->obtenerExistenciaAnterior($codigoItem, $compraData['CodUbic']),
                'CantidadU' => $cantidad,
                'Costo' => $precioUnitario,
                'TotalItem' => $montoItem,
                //'Precio' => $precioUnitario,
                'NroLote' => $lote,
                'FechaE' => date('Y-m-d H:i:s'),
                'FechaV' => $fechaVencimiento,
                'EsServ' => 0,
                'EsUnid' => 1,
                'EsPesa' => 0,
                'EsExento' => 0,
                'DEsLote' => !empty($lote) ? 1 : 0,
                'MtoTax' => 0 // Se calcula después si es necesario
            ];
            
            // Insertar en SAITEMCOM
            $this->db->table('SAITEMCOM')->insert($itemCompraData);
            
            // Actualizar inventario
            $this->actualizarInventario($codProd, $compraData['CodUbic'], $cantidad, $precioUnitario);
            
            // Crear registro de lote si existe
            if (!empty($lote)) {
                $this->crearRegistroLote($codProd, $compraData, $lote, $cantidad, $precioUnitario, $fechaVencimiento);
            }
            
            $nroLinea++;
        }
    }
    
    /**
     * Obtener o crear proveedor
     */
    private function obtenerOCrearProveedor($emisor, $rutProveedor)
    {
        // Buscar proveedor existente por RUT
        $proveedor = $this->db->table('SAPROV')
            ->where('ID3', $rutProveedor)
            ->get()
            ->getRowArray();
        
        if ($proveedor) {
            return $proveedor['CodProv'];
        }
        
        // Crear nuevo proveedor
        // $correlativoProv = $this->obtenerCorrelativo('PrxProv');
        // if (!$correlativoProv) {
        //     throw new \Exception('Error al obtener correlativo para proveedor');
        // }
        
        // $proveedorData = [
        //     'CodProv' => 'P' . str_pad($correlativoProv['NumeroD'], 6, '0', STR_PAD_LEFT),
        //     'Descrip' => (string)$emisor->RznSoc,
        //     'Direc1' => (string)$emisor->DirOrigen,
        //     'Ciudad' => (string)$emisor->CiudadOrigen,
        //     'ID3' => $rutProveedor,
        //     'Activo' => 1,
        //     'EsProvee' => 1
        // ];
        
        // $this->db->table('SAPROV')->insert($proveedorData);
        
        return $proveedorData['CodProv'];
    }
    
    /**
     * Obtener o crear producto
     */
    private function obtenerOCrearProducto($codigoItem, $detalle, $codigoBarras = '')
    {
        // Buscar producto existente
        $producto = $this->db->table('SAPROD')
            ->where('Refere', $codigoBarras)
            ->get()
            ->getRowArray();
        
        if ($producto) {
            return $codigoItem;
        }
        
        // Crear nuevo producto
        // $productoData = [
        //     'CodProd' => $codigoItem,
        //     'Descrip' => (string)$detalle->DscItem,
        //     'Activo' => 1,
        //     'Refere' => $codigoBarras,
        //     'Unidad' => 'UND',
        //     'CantEmpaq' => 1,
        //     'Precio1' => (float)$detalle->PrcItem * 1.3, // Precio con margen del 30%
        //     'CostAct' => (float)$detalle->PrcItem,
        //     'CostPro' => (float)$detalle->PrcItem,
        //     'Existen' => 0,
        //     'EsImport' => 1,
        //     'ExDecimal' => 0,
        //     'DEsLote' => 0,
        //     'DEsVence' => 0
        // ];
        
        // $this->db->table('SAPROD')->insert($productoData);
        
        // return $codigoItem;
    }
    
    /**
     * Crear registro de lote
     */
    private function crearRegistroLote($codigoItem, $compraData, $lote, $cantidad, $costo, $fechaVencimiento)
    {

        log_message('error', 'entra a salote');
        $loteData = [
            'CodProd' => $codigoItem,
            // 'NroUnico' => $compraData['NroUnico'],
            'CodUbic' => $compraData['CodUbic'],
            'NroLote' => $lote,
            'Costo' => $costo,
            'Precio1' => $costo * 1.3, // Precio con margen
            'Cantidad' => $cantidad,
            //'CantidadU' => $cantidad,
            'FechaE' => date('Y-d-m H:i:s'),
            'FechaV' => $fechaVencimiento,
            'CodSucu' => $compraData['CodSucu']
        ];
        
        $this->db->table('SALOTE')->insert($loteData);
    }
    
    /**
     * Actualizar inventario
     */
    private function actualizarInventario($codProd, $codUbic, $cantidad, $costo)
    {
        // Verificar si existe el registro en SAEXIS
        $existencia = $this->db->table('SAEXIS')
            ->where('CodProd', $codProd)
            ->where('CodUbic', $codUbic)
            ->get()
            ->getRowArray();
        
        if ($existencia) {
            // Actualizar la existencia
            $nuevaExistencia = intval($existencia['Existen']) + $cantidad;
            
            $this->db->table('SAEXIS')
                ->where('CodProd', $codProd)
                ->where('CodUbic', $codUbic)
                ->update(['Existen' => $nuevaExistencia]);
        } else {
            // Crear un nuevo registro
            $this->db->table('SAEXIS')->insert([
                'CodProd' => $codProd,
                'CodUbic' => $codUbic,
                'Existen' => $cantidad,
                'CodSucu' => '00000'
            ]);
        }
        
        // Actualizar también en SAPROD
        $this->db->table('SAPROD')
            ->where('CodProd', $codProd)
            //->set('Existen', 'Existen + ' . $cantidad, false)
            //->set('CostAct', $costo)
            ->update(['Existen' => $nuevaExistencia]);
    }
    
    /**
     * Obtener existencia anterior
     */
    private function obtenerExistenciaAnterior($codProd, $codUbic)
    {
        $existencia = $this->db->table('SAEXIS')
            ->select('Existen')
            ->where('CodProd', $codProd)
            ->where('CodUbic', $codUbic)
            ->get()
            ->getRowArray();
        
        return $existencia['Existen'] ?? 0;
    }
    
    /**
     * Obtener correlativo
     */
    private function obtenerCorrelativo($tipoDoc)
    {
        $correlativo = $this->db->table('SACORRELSIS')
            ->where('FieldName', $tipoDoc)
            ->get()
            ->getRowArray();
        
        if (!$correlativo) {
            return null;
        }
        
        $nroUnico = intval($correlativo['ValueInt']) + 1;
        
        $this->db->table('SACORRELSIS')
            ->where('FieldName', $tipoDoc)
            ->update(['ValueInt' => $nroUnico]);
        
        return [
            'NroUnico' => $nroUnico,
            'NumeroD' => $nroUnico
        ];
    }
    
    /**
     * Convertir fecha del formato YYYY-MM-DD a MM-DD-YYYY H:i
     */
    private function convertirFecha($fecha)
    {
        $fechaObj = \DateTime::createFromFormat('Y-m-d', $fecha);
        if ($fechaObj) {
            return $fechaObj->format('m-d-Y H:i');
        }
        return date('m-d-Y H:i');
    }
    
    /**
     * Listar compras
     */
    public function listado()
    {
        $compras = $this->db->table('SACOMP')
            ->select('SACOMP.NumeroD, SACOMP.FechaE, SACOMP.CodProv, SAPROV.Descrip as NombreProveedor, SACOMP.MtoTotal, SACOMP.NroCtrol')
            ->join('SAPROV', 'SACOMP.CodProv = SAPROV.CodProv', 'left')
            ->where('SACOMP.TipoCom', 'J')
            ->orWhere('SACOMP.TipoCom', 'H')
            ->orderBy('SACOMP.FechaE', 'DESC')
            ->get()
            ->getResultArray();
        
        $data = [
            'compras' => $compras
        ];
        
        return view('compras/listado', $data);
    }
    
    /**
     * Ver detalle de compra
     */
    public function ver($numeroD)
    {
        $compra = $this->db->table('SACOMP')
            ->select('SACOMP.*, SAPROV.Descrip as NombreProveedor')
            ->join('SAPROV', 'SACOMP.CodProv = SAPROV.CodProv', 'left')
            ->where('SACOMP.NumeroD', $numeroD)
            ->where('SACOMP.TipoCom', 'J')
            ->orWhere('SACOMP.TipoCom', 'J')
            ->get()
            ->getRowArray();
        
        if (!$compra) {
            return redirect()->to('/compras/listado')->with('error', 'Compra no encontrada');
        }
        
        $detalles = $this->db->table('SAITEMCOM')
            ->where('NumeroD', $numeroD)
            ->where('TipoCom', 'A')
            ->orderBy('NroLinea', 'ASC')
            ->get()
            ->getResultArray();
        
        $data = [
            'compra' => $compra,
            'detalles' => $detalles
        ];
        
        return view('compras/ver', $data);
    }
}