<?= $this->extend('layouts/main') ?>

<?= $this->section('title') ?>
Detalle de Orden #<?= $orden['NumeroD'] ?>
<?= $this->endSection() ?>



<?= $this->section('content') ?>
<div class="techwave_fn_user_billing_page">
    <div class="container small">
        <div class="fn__title_holder">
            <h3>Detalle de Orden #<?= $orden['NumeroD'] ?></h3>
            <p>Fecha: <?= date('d/m/Y H:i', strtotime($orden['FechaT'])) ?></p>
        </div>

        <!-- Scanner Interface -->
        <div id="scannerInterface" class="mb-4">
            <div id="messageArea"></div>
            <input type="text" class="techwave_fn_input" id="scanInput" placeholder="Escanear producto..." autofocus>
        </div>

        <div class="fn__table_wrap">
            <table class="display">
                <thead>
                    <tr>
                        <th>Código</th>
                        <th>Descripción</th>
                        <th>Cantidad</th>
                        <th>Escaneado</th>
                        <th>Estado</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($detalles as $detalle): ?>
                        <tr data-code="<?= $detalle['CodItem'] ?>" data-quantity="<?= $detalle['Cantidad'] ?>">
                            <td><?= $detalle['CodItem'] ?></td>
                            <td><?= $detalle['Descrip'] ?></td>
                            <td><?= $detalle['Cantidad'] ?></td>
                            <td class="scanned-count">0</td>
                            <td class="status-cell"><?= $detalle['Descrip10'] ?? 'PENDIENTE' ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const orderId = '<?= $orden['NumeroD'] ?>';
        const scannedProducts = {};
        const messageArea = document.getElementById('messageArea');
        const scanInput = document.getElementById('scanInput');

        scanInput.addEventListener('keydown', async function (event) {
            if (event.key === 'Enter') {
                const barcode = this.value.toUpperCase();
                this.value = '';

                const row = document.querySelector(`tr[data-code="${barcode}"]`);
                if (!row) {
                    showMessage('error', `Producto ${barcode} no encontrado`);
                    return;
                }

                const quantity = parseInt(row.dataset.quantity);
                const currentCount = scannedProducts[barcode] || 0;

                if (currentCount >= quantity) {
                    showMessage('warning', 'Producto ya escaneado completamente');
                    return;
                }

                scannedProducts[barcode] = currentCount + 1;
                row.querySelector('.scanned-count').textContent = scannedProducts[barcode];

                if (scannedProducts[barcode] === quantity) {
                    row.querySelector('.status-cell').textContent = 'VERIFICADO';
                    await updateProduct(barcode);
                }
            }
        });

        async function updateProduct(barcode) {
            try {
                const response = await fetch('/ordenes/actualizar-producto', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify({ orderId, barcode, status: 'VERIFICADO' })
                });

                if (!response.ok) throw new Error('Error al actualizar');
                showMessage('success', 'Producto verificado correctamente');

            } catch (error) {
                showMessage('error', 'Error al actualizar el producto');
            }
        }

        function showMessage(type, text) {
            messageArea.innerHTML = `<div class="alert alert-${type}">${text}</div>`;
            setTimeout(() => messageArea.innerHTML = '', 3000);
        }
    });
</script>
<style>
    .alert {
        padding: 1rem;
        margin-bottom: 1rem;
        border-radius: 0.25rem;
    }

    .alert-error {
        background-color: #fee2e2;
        color: #dc2626;
    }

    .alert-warning {
        background-color: #fef3c7;
        color: #d97706;
    }

    .alert-success {
        background-color: #d1fae5;
        color: #059669;
    }
</style>
<?= $this->endSection() ?>