<?php

namespace App\Services;

use Dompdf\Dompdf;
use Dompdf\Options;

class EmailService
{
    protected $email;
    
    public function __construct()
    {
        $this->email = \Config\Services::email();
        
        // Configuración del servidor de correo
        $config = [
            'protocol' => 'smtp',
            'SMTPHost' => 'mail.privateemail.com',
            'SMTPPort' => 465,
            'SMTPUser' => 'administracion@membeauty.com',
            'SMTPPass' => 'Noviembre1991', // Reemplazar con la contraseña real
            'SMTPCrypto' => 'ssl',
            'mailType' => 'html',
            'charset' => 'utf-8',
            'newline' => "\r\n",
            'SMTPAuth' => true,
        ];
        
        $this->email->initialize($config);
    }
    
    public function sendCotizacionEmail($to, $cotizacion, $detalles, $empresa)
    {
        // Configurar correo
        $this->email->setFrom('admin@halldev.lat', $empresa['nombre']);
        $this->email->setTo($to);
        $this->email->setSubject('Cotización #' . $cotizacion['NumeroD'] . ' - ' . $empresa['nombre']);
        
        // Mensaje HTML
        $message = '<html><body>';
        $message .= '<h2>Cotización #' . $cotizacion['NumeroD'] . '</h2>';
        $message .= '<p>Estimado cliente,</p>';
        $message .= '<p>Adjunto encontrará la cotización solicitada. Esta cotización es válida por 30 días a partir de la fecha de emisión.</p>';
        $message .= '<p>Para cualquier consulta, no dude en contactarnos.</p>';
        $message .= '<p>Saludos cordiales,</p>';
        $message .= '<p><strong>' . $empresa['nombre'] . '</strong><br>';
        $message .= $empresa['direccion'] . '<br>';
        $message .= 'Tel: ' . $empresa['telefono'] . '</p>';
        $message .= '</body></html>';
        
        $this->email->setMessage($message);
        
        // Generar PDF para adjuntar
        $dompdf = new Dompdf();
        
        // Preparar datos para la vista
        $data = [
            'cotizacion' => $cotizacion,
            'detalles' => $detalles,
            'empresa' => $empresa
        ];
        
        // Renderizar vista HTML para PDF
        $html = view('cotizaciones/pdf_template', $data);
        
        // Cargar HTML en DOMPDF
        $dompdf->loadHtml($html);
        
        // Configurar tamaño de papel y orientación
        $dompdf->setPaper('A4', 'portrait');
        
        // Renderizar PDF
        $dompdf->render();
        
        // Obtener el contenido del PDF como string
        $pdfContent = $dompdf->output();
        
        // Guardar el PDF temporalmente
        $tempFile = tempnam(sys_get_temp_dir(), 'cotizacion_');
        file_put_contents($tempFile, $pdfContent);
        
        // Adjuntar PDF
        $this->email->attach($tempFile, 'attachment', 'Cotizacion_' . $cotizacion['NumeroD'] . '.pdf');
        
        // Enviar correo
        $result = $this->email->send();
        
        // Eliminar archivo temporal
        @unlink($tempFile);
        
        if (!$result) {
            log_message('error', 'Error al enviar correo: ' . $this->email->printDebugger(['headers']));
        }
        
        return $result;
    }
}