<?php

namespace App\Models;

use CodeIgniter\Model;

class OrdenesModel extends Model
{
    public function getOrdenes($start = 0, $length = 10, $search = '', $orderColumn = 'FechaT', $orderDir = 'DESC')
    {
        $db = \Config\Database::connect();
       
        // Calcular fecha de 15 días atrás
        $fechaLimite = date('Y-m-d', strtotime('-45 days'));
        
        $builder = $db->table('SAFACT f')
            ->select('f.NumeroD, f.FechaT, f.CodUsua, f.TipoFac, 
                    (SELECT COUNT(*) FROM SAITEMFAC WHERE NumeroD = f.NumeroD) as total_productos, 
                    f.CodSucu, f.Notas10')
            ->where('f.TipoFac', 'A')
            ->where('f.FechaT >=', $fechaLimite)
            ->groupStart()
                ->where('f.Notas10 IS NULL')
                ->orWhere('f.Notas10 !=', 'DESPACHADO')
            ->groupEnd();

        // Aplicar búsqueda si existe
        if (!empty($search)) {
            $builder->groupStart()
                   ->like('f.NumeroD', $search)
                   ->orLike('f.CodUsua', $search)
                   ->groupEnd();
        }

        // Obtener total de registros filtrados
        $totalFiltered = $builder->countAllResults(false);

        // Obtener total de registros (solo de los últimos 15 días)
        $totalRecords = $db->table('SAFACT')
                          ->where('TipoFac', 'A')
                          ->where('FechaT >=', $fechaLimite)
                          ->countAllResults();

        // Aplicar ordenamiento y paginación
        $builder->orderBy($orderColumn, $orderDir)
                ->limit($length, $start);

        // Obtener los datos
        $results = $builder->get()->getResultArray();

        return [
            'data' => $results,
            'recordsFiltered' => $totalFiltered,
            'recordsTotal' => $totalRecords
        ];
    }

    public function getDetalleOrden($numeroD)
    {
        $db = \Config\Database::connect();
        // $orden = $db->table('SAFACT f')
        //     ->select('f.*, u.Descrip as nombre_usuario')
        //     ->join('SAUSUARI u', 'f.CodUsuario = u.CodUsua', 'left')
        //     ->where('f.NumeroD', $numeroD)
        //     ->get()
        //     ->getRowArray();

        // $detalles = $db->table('SAITENFAC i')
        //     ->select('i.*, p.Descrip')
        //     ->join('SAPROD p', 'i.CodItem = p.CodProd')
        //     ->where('i.NumeroD', $numeroD)
        //     ->get()
        //     ->getResultArray();
        // Primera consulta: Obtener datos de la orden sin el join problemático
    $orden = $db->table('SAFACT f')
        ->select('f.*')
        ->where('f.NumeroD', $numeroD)
        ->get()
        ->getRowArray();

    // Segunda consulta: Obtener los detalles de los productos
    $detalles = $db->table('SAITEMFAC i')
        ->select('i.*, p.Descrip')
        ->join('SAPROD p', 'i.CodItem = p.CodProd')
        ->where('i.NumeroD', $numeroD)
        ->get()
        ->getResultArray();

        return [
            'orden' => $orden,
            'detalles' => $detalles
        ];
    }
}