<?= $this->extend('layouts/main') ?>

<?= $this->section('title') ?>
Detalle de Orden #<?= $orden['NumeroD'] ?>
<?= $this->endSection() ?>



<?= $this->section('content') ?>
<div class="techwave_fn_user_billing_page">
    <div class="container small">
        <div class="fn__title_holder">
            <h3>Detalle de Orden #<?= $orden['NumeroD'] ?></h3>
            <p>Fecha: <?= date('d/m/Y H:i', strtotime($orden['FechaT'])) ?></p>
        </div>

        <!-- Scanner Interface -->
        <div id="scannerInterface" class="mb-4">
            <div id="messageArea"></div>
            <input type="text" class="techwave_fn_input" id="scanInput" placeholder="Escanear producto...">
        </div>

        <div class="fn__table_wrap">
            <table class="display">
                <thead>
                    <tr>
                        <th>Código</th>
                        <th>Descripción</th>
                        <th>Cantidad</th>
                        <th>Escaneado</th>
                        <th>Estado</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($detalles as $detalle): ?>
                        <tr data-code="<?= $detalle['CodItem'] ?>" data-ref="<?= $detalle['Refere'] ?>" data-scanned="<?= $detalle['Descrip9'] ?>" data-quantity="<?= $detalle['Cantidad'] ?>">
                            <td><?= $detalle['CodItem'] ?></td>
                            <td><?= $detalle['Descrip'] ?></td>
                            <td><?= $detalle['Cantidad'] ?></td>
                            <!-- <td class="scanned-count">0</td> -->
                             <td class="scanned-count"><?= $detalle['Descrip9'] ?? 0 ?></td>
                            <td class="status-cell"><?= $detalle['Descrip10'] ?? 'PENDIENTE' ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            <div class="mt-4">
                <button id="completarBtn" class="btn btn-success" style="display: none;">
                    Completar Despacho
                </button>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const orderId = '<?= $orden['NumeroD'] ?>';
        const scannedProducts = {};
        const messageArea = document.getElementById('messageArea');
        const scanInput = document.getElementById('scanInput');
        initBarcodeScanner();

        checkAllComplete();

        scanInput.addEventListener('keydown', async function (event) {
            if (event.key === 'Enter') {
                const barcode = this.value.toUpperCase();
                this.value = '';

                const row = document.querySelector(`tr[data-ref="${barcode}"]`);
                if (!row) {
                    showMessage('error', `Producto ${barcode} no encontrado`);
                    return;
                }

                const quantity = parseInt(row.dataset.quantity);
                //const currentCount = scannedProducts[barcode] || 0;
                const currentCount = parseInt(row.querySelector('.scanned-count').textContent) || 0;

                if (currentCount >= quantity) {
                    showMessage('warning', 'Producto ya escaneado completamente');
                    return;
                }

                scannedProducts[barcode] = currentCount + 1;
                row.querySelector('.scanned-count').textContent = scannedProducts[barcode];

                if (scannedProducts[barcode] === quantity) {
                    row.querySelector('.status-cell').textContent = 'VERIFICADO';
                    await updateProduct(barcode);
                }
                else {

                    row.querySelector('.status-cell').textContent = 'PENDIENTE';

                    await updateProduct(barcode);

                }
            }
        });

        // Función para manejar entrada del escáner de código de barras
        function initBarcodeScanner() {
            let scanBuffer = '';
            let scanTimeout;
            
            // Detectar entrada del escáner (caracteres rápidos seguidos de Enter)
            document.addEventListener('keydown', function(event) {
                // Si es Enter y hay buffer, procesar como código escaneado
                console.log("SCANNER FUNCT");
                if (event.key === 'Enter' && scanBuffer.length > 0) {
                    event.preventDefault();
                    console.log(scanBuffer);
                    processBarcodeInput(scanBuffer.trim().toUpperCase());
                    scanBuffer = '';
                    clearTimeout(scanTimeout);
                    return;
                }
                
                // Si es un caracter imprimible, agregarlo al buffer
                if (event.key.length === 1) {
                    scanBuffer += event.key;
                    
                    // Reset timeout - si no hay más input en 100ms, limpiar buffer
                    clearTimeout(scanTimeout);
                    scanTimeout = setTimeout(() => {
                        scanBuffer = '';
                    }, 100);
                }
            });
        }

        // Procesar el código escaneado
        async function processBarcodeInput(barcode) {
            console.log('Código escaneado:', barcode);
            
            //const row = document.querySelector(`tr[data-code="${barcode}"]`);
            const row = document.querySelector(`tr[data-ref="${barcode}"]`);
            //if (!row) {
                //showMessage('error', `Producto ${barcode} no encontrado`);
                if (!row) {
                    showMessage('error', `Producto ${barcode} no encontrado`);
                    return;
                }
                //return;
            //}

            const quantity = parseInt(row.dataset.quantity);
            //const currentCount = parseInt(row.dataset.scanned) || 0;

            //const currentCount = scannedProducts[barcode] || 0;
            const currentCount = parseInt(row.querySelector('.scanned-count').textContent) || 0;

            if (currentCount >= quantity) {
                showMessage('warning', 'Producto ya escaneado completamente');
                //const audio = new Audio('http://18.116.49.39/assets/sounds/alerta.mp3');
                //audio.play();
                return;
            }

            scannedProducts[barcode] = currentCount + 1;
            //row.querySelector('.scanned-count').textContent = scannedProducts[barcode];

            if (scannedProducts[barcode] === quantity) {
                row.querySelector('.status-cell').textContent = 'VERIFICADO';
                await updateProduct(barcode);
            }
            else {
                row.querySelector('.status-cell').textContent = 'PENDIENTE';
                await updateProduct(barcode);

            }
            
        }

        async function updateProduct(barcode) {
            try {
                const response = await fetch('/despachos/actualizar-producto', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify({ orderId, barcode })
                });

                const result = await response.json();
                if (!response.ok) throw new Error('Error al actualizar');

                // Actualizar interfaz con datos del servidor
                const row = document.querySelector(`tr[data-ref="${barcode}"]`);
                row.querySelector('.scanned-count').textContent = result.scannedCount;
                row.querySelector('.status-cell').textContent = result.status;
                
                scannedProducts[barcode] = result.scannedCount;
                
                //showMessage('success', 'Producto verificado correctamente');
                //const audio = new Audio('http://18.116.49.39/assets/sounds/correct.mp3');
                //audio.play();
                checkAllComplete();

            } catch (error) {
                showMessage('error', 'Error al actualizar el producto');
                //const audio = new Audio('http://18.116.49.39/assets/sounds/alerta.mp3');
                //audio.play();
            }
        }
        function checkAllComplete() {
            const rows = document.querySelectorAll('tbody tr');
            let allComplete = true;
            
            rows.forEach(row => {
                const quantity = parseInt(row.dataset.quantity);
                const scanned = parseInt(row.querySelector('.scanned-count').textContent);
                if (scanned < quantity) allComplete = false;
            });
            
            document.getElementById('completarBtn').style.display = allComplete ? 'block' : 'none';
        }

        document.getElementById('completarBtn').addEventListener('click', async function() {
            try {
                const response = await fetch('/despachos/completarDespacho', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify({ orderId })
                });

                if (!response.ok) throw new Error('Error al completar');
                
                showMessage('success', 'Despacho completado exitosamente');
                this.style.display = 'none';
                
            } catch (error) {
                showMessage('error', 'Error al completar el despacho');
            }
        });

        function showMessage(type, text) {
            messageArea.innerHTML = `<div class="alert alert-${type}">${text}</div>`;
            setTimeout(() => messageArea.innerHTML = '', 3000);
        }
    });
</script>
<style>
    .alert {
        padding: 1rem;
        margin-bottom: 1rem;
        border-radius: 0.25rem;
    }

    .alert-error {
        background-color: #fee2e2;
        color: #dc2626;
    }

    .alert-warning {
        background-color: #fef3c7;
        color: #d97706;
    }

    .alert-success {
        background-color: #d1fae5;
        color: #059669;
    }
</style>
<?= $this->endSection() ?>