<?php

namespace App\Models;

use CodeIgniter\Model;

class OrdenesModelbck extends Model
{
    public function getOrdenes($start = 0, $length = 10, $search = '', $orderColumn = 'FechaT', $orderDir = 'DESC')
    {
        $db = \Config\Database::connect();
        // $builder = $db->table('SAFACT f')
        //     ->select('f.NumeroD, f.FechaT, f.CodUsua, f.TipoFac, 
        //                 (SELECT COUNT(*) FROM SAITEMFAC WHERE NumeroD = f.NumeroD) as total_productos,f.CodSucu')
        //     ->where('f.TipoFac', 'A');

        // // Obtener total de registros filtrados
        // $totalFiltered = $builder->countAllResults(false);

        // // Aplicar ordenamiento y paginación
        // $builder->orderBy($orderColumn, $orderDir)
        //     ->limit($length, $start);

        // // Obtener los datos
        // $results = $builder->get()->getResultArray();

        // return [
        //     'data' => $results,
        //     'recordsFiltered' => $totalFiltered,
        //     'recordsTotal' => $db->table('SAFACT')->where('TipoFac', 'A')->countAllResults()
        // ];
        // Calcular fecha de 15 días atrás
        $fechaLimite = date('Y-m-d', strtotime('-15 days'));
        
        $builder = $db->table('SAFACT f')
            ->select('f.NumeroD, f.FechaT, f.CodUsua, f.TipoFac, 
                    (SELECT COUNT(*) FROM SAITEMFAC WHERE NumeroD = f.NumeroD) as total_productos, 
                    f.CodSucu')
            ->where('f.TipoFac', 'A')
            ->where('f.FechaT >=', $fechaLimite);

        // Aplicar búsqueda si existe
        if (!empty($search)) {
            $builder->groupStart()
                   ->like('f.NumeroD', $search)
                   ->orLike('f.CodUsua', $search)
                   ->groupEnd();
        }

        // Obtener total de registros filtrados
        $totalFiltered = $builder->countAllResults(false);

        // Obtener total de registros (solo de los últimos 15 días)
        $totalRecords = $db->table('SAFACT')
                          ->where('TipoFac', 'A')
                          ->where('FechaT >=', $fechaLimite)
                          ->countAllResults();

        // Aplicar ordenamiento y paginación
        $builder->orderBy($orderColumn, $orderDir)
                ->limit($length, $start);

        // Obtener los datos
        $results = $builder->get()->getResultArray();

        return [
            'data' => $results,
            'recordsFiltered' => $totalFiltered,
            'recordsTotal' => $totalRecords
        ];
    }

    public function getDetalleOrden($numeroD)
    {
        $db = \Config\Database::connect();
        // $orden = $db->table('SAFACT f')
        //     ->select('f.*, u.Descrip as nombre_usuario')
        //     ->join('SAUSUARI u', 'f.CodUsuario = u.CodUsua', 'left')
        //     ->where('f.NumeroD', $numeroD)
        //     ->get()
        //     ->getRowArray();

        // $detalles = $db->table('SAITENFAC i')
        //     ->select('i.*, p.Descrip')
        //     ->join('SAPROD p', 'i.CodItem = p.CodProd')
        //     ->where('i.NumeroD', $numeroD)
        //     ->get()
        //     ->getResultArray();
        // Primera consulta: Obtener datos de la orden sin el join problemático
    $orden = $db->table('SAFACT f')
        ->select('f.*')
        ->where('f.NumeroD', $numeroD)
        ->get()
        ->getRowArray();

    // Segunda consulta: Obtener los detalles de los productos
    $detalles = $db->table('SAITEMFAC i')
        ->select('i.*, p.Descrip')
        ->join('SAPROD p', 'i.CodItem = p.Descrip2')
        ->where('i.NumeroD', $numeroD)
        ->get()
        ->getResultArray();

        return [
            'orden' => $orden,
            'detalles' => $detalles
        ];
    }
}