<?php

namespace App\Models;

use CodeIgniter\Model;

class ClienteModel extends Model
{
    protected $table = 'SACLIE';
    protected $primaryKey = 'CodClie';
    
    public function getClientes($limit = 100)
    {
        return $this->select('CodClie, Descrip, ID3, Activo, Telef, Email')
                    ->where('Activo', 1)
                    //->limit($limit)
                    ->findAll();
    }
    
    public function getCliente($codClie)
    {
        return $this->find($codClie);
    }
    
    public function buscarClientes($term)
    {
        return $this->like('Descrip', $term)
                    ->orLike('ID3', $term)
                    ->orLike('CodClie', $term)
                    ->where('Activo', 1)
                    ->limit(10)
                    ->findAll();
    }
}