<?= $this->extend('layouts/main') ?>

<?= $this->section('title') ?>
Crear Nuevo Cliente
<?= $this->endSection() ?>

<?= $this->section('page_title') ?>
CREAR NUEVO CLIENTE
<?= $this->endSection() ?>

<?= $this->section('content') ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h4 class="card-title">Datos del Cliente</h4>
                        <a href="<?= base_url('archivos/clientes') ?>" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Volver
                        </a>
                        
                        <a href="<?= base_url('archivos') ?>">
                            <i class="fas fa-folder"></i> Archivos
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <?php if (session()->has('error')): ?>
                        <div class="alert alert-danger">
                            <?= session('error') ?>
                        </div>
                    <?php endif; ?>
                    
                    <?php if (session()->has('errors')): ?>
                        <div class="alert alert-danger">
                            <ul>
                                <?php foreach (session('errors') as $error): ?>
                                    <li><?= $error ?></li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    <?php endif; ?>
                    
                    <form action="<?= base_url('clientes/guardar') ?>" method="post">
                        <?= csrf_field() ?>
                        
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label for="codclie" class="form-label">Último código</label>
                                <input type="text" class="form-control" value="<?= $ultimo_codigo ?>" readonly>
                            </div>
                            <div class="col-md-6">
                                <label for="codclie" class="form-label">Código</label>
                                <input type="text" class="form-control" id="codclie" name="codclie" value="<?= $ultimo_codigo ?>" required>
                            </div>
                        </div>
                        
                        <div class="row mb-3">
                            <div class="col-md-8">
                                <label for="descrip" class="form-label">Descripción / Nombre</label>
                                <input type="text" class="form-control" id="descrip" name="descrip" value="<?= old('descrip') ?>" required>
                            </div>
                            <div class="col-md-4">
                                <label for="activo" class="form-label d-block">&nbsp;</label>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="activo" name="activo" value="1" checked>
                                    <label class="form-check-label" for="activo">Activo</label>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row mb-3">
                            <div class="col-md-4">
                                <label for="tipoid3" class="form-label">Tipo Identificación</label>
                                <select class="form-select" id="tipoid3" name="tipoid3">
                                    <option value="1" <?= old('tipoid3') == 'CÉDULA' ? 'selected' : '' ?>>CÉDULA</option>
                                    <option value="0" <?= old('tipoid3') == 'JURÍDICO' ? 'selected' : '' ?>>JURÍDICO</option>
                                </select>
                            </div>
                            <div class="col-md-6">
                                <label for="id3" class="form-label">Identificación Fiscal</label>
                                <input type="text" class="form-control" id="id3" name="id3" value="<?= old('id3') ?>" required placeholder="Ej: 77105708-K">
                            </div>
                            <div class="col-md-2">
                                <label class="form-label d-block">&nbsp;</label>
                                <button type="button" class="btn btn-info btn-sm w-100" id="consultarSII" title="Consultar datos en SII Chile">
                                    <i class="fas fa-search"></i> SII
                                </button>
                            </div>
                        </div>
                        
                        <!-- Spinner para consulta SII -->
                        <div class="row mb-3 d-none" id="siiSpinner">
                            <div class="col-12">
                                <div class="alert alert-info d-flex align-items-center">
                                    <div class="spinner-border spinner-border-sm me-2" role="status">
                                        <span class="visually-hidden">Consultando...</span>
                                    </div>
                                    Consultando información en SII Chile...
                                </div>
                            </div>
                        </div>
                        
                        <!-- Tabs Navigation -->
                        <div class="techwave_fn_tabs" data-type="tab">
                            <div class="tab_in">
                                <a href="#" class="tab_link active" data-tab="datos">Datos principales</a>
                                <a href="#" class="tab_link" data-tab="otros">Otros datos</a>
                                <a href="#" class="tab_link" data-tab="financieros">Datos financieros</a>
                            </div>
                        </div>
                        
                        <div class="tab_content_container p-3 border border-top-0 rounded-bottom">
                            <!-- Pestaña de Datos Principales -->
                            <div class="tab_content active" id="datos">
                                <div class="row mb-3">
                                    <div class="col-md-6">
                                        <label for="represent" class="form-label">Representante</label>
                                        <input type="text" class="form-control" id="represent" name="represent" value="<?= old('represent') ?>">
                                    </div>
                                    <div class="col-md-6">
                                        <label for="clase" class="form-label">Clase</label>
                                        <input type="text" class="form-control" id="clase" name="clase" value="<?= old('clase') ?>">
                                    </div>
                                </div>
                                
                                <div class="row mb-3">
                                    <div class="col-12">
                                        <label for="direc1" class="form-label">Dirección 1</label>
                                        <input type="text" class="form-control" id="direc1" name="direc1" value="<?= old('direc1') ?>">
                                    </div>
                                </div>
                                
                                <div class="row mb-3">
                                    <div class="col-12">
                                        <label for="direc2" class="form-label">Dirección 2</label>
                                        <input type="text" class="form-control" id="direc2" name="direc2" value="<?= old('direc2') ?>">
                                    </div>
                                </div>
                                
                                <!-- Ubicación Geográfica -->
                                <div class="row mb-3">
                                    <div class="col-md-3">
                                        <label for="pais" class="form-label">País <span class="text-danger">*</span></label>
                                        <select class="form-select" id="pais" name="pais" required>
                                            <option value="">Seleccione un país</option>
                                            <?php if (isset($paises) && is_array($paises)): ?>
                                                <?php foreach ($paises as $pais): ?>
                                                    <option value="<?= $pais['Pais'] ?>" 
                                                            <?= old('pais') == $pais['Pais'] ? 'selected' : '' ?>>
                                                        <?= htmlspecialchars($pais['Descrip']) ?>
                                                    </option>
                                                <?php endforeach; ?>
                                            <?php endif; ?>
                                        </select>
                                    </div>
                                    <div class="col-md-3">
                                        <label for="estado" class="form-label">Estado/Departamento <span class="text-danger">*</span></label>
                                        <select class="form-select" id="estado" name="estado" required disabled>
                                            <option value="">Seleccione primero un país</option>
                                        </select>
                                        <div class="spinner-border spinner-border-sm d-none" role="status" id="estadoSpinner">
                                            <span class="visually-hidden">Cargando...</span>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <label for="ciudad" class="form-label">Ciudad <span class="text-danger">*</span></label>
                                        <select class="form-select" id="ciudad" name="ciudad" required disabled>
                                            <option value="">Seleccione primero un estado</option>
                                        </select>
                                        <div class="spinner-border spinner-border-sm d-none" role="status" id="ciudadSpinner">
                                            <span class="visually-hidden">Cargando...</span>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <label for="municipio" class="form-label">Municipio</label>
                                        <select class="form-select" id="municipio" name="municipio" disabled>
                                            <option value="">Seleccione primero una ciudad</option>
                                        </select>
                                        <div class="spinner-border spinner-border-sm d-none" role="status" id="municipioSpinner">
                                            <span class="visually-hidden">Cargando...</span>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="row mb-3">
                                    <div class="col-md-3">
                                        <label for="zipcode" class="form-label">Zona postal</label>
                                        <input type="text" class="form-control" id="zipcode" name="zipcode" value="<?= old('zipcode') ?>">
                                    </div>
                                    <div class="col-md-3">
                                        <label for="telef" class="form-label">Teléfonos</label>
                                        <input type="text" class="form-control" id="telef" name="telef" value="<?= old('telef') ?>">
                                    </div>
                                    <div class="col-md-3">
                                        <label for="movil" class="form-label">Móvil celular</label>
                                        <input type="text" class="form-control" id="movil" name="movil" value="<?= old('movil') ?>">
                                    </div>
                                    <div class="col-md-3">
                                        <label for="fax" class="form-label">Fax</label>
                                        <input type="text" class="form-control" id="fax" name="fax" value="<?= old('fax') ?>">
                                    </div>
                                </div>
                                
                                <div class="row mb-3">
                                    <div class="col-md-6">
                                        <label for="email" class="form-label">E-mail</label>
                                        <input type="email" class="form-control" id="email" name="email" value="<?= old('email') ?>">
                                    </div>
                                    <div class="col-md-6">
                                        <label for="fechae" class="form-label">Fecha inicio</label>
                                        <input type="date" class="form-control" id="fechae" name="fechae" value="<?= date('Y-m-d') ?>" readonly>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Pestaña de Otros Datos -->
                            <div class="tab_content" id="otros">
                                <div class="row mb-3">
                                    <div class="col-md-4">
                                        <label for="tipocli" class="form-label">Tipo Cliente</label>
                                        <select class="form-select" id="tipocli" name="tipocli">
                                            <option value="1" selected>REGULAR</option>
                                            <option value="2">MAYORISTA</option>
                                            <option value="3">DISTRIBUIDOR</option>
                                        </select>
                                    </div>
                                    <div class="col-md-4">
                                        <label for="tipopvp" class="form-label">Tipo PVP</label>
                                        <select class="form-select" id="tipopvp" name="tipopvp">
                                            <option value="1" selected>PRECIO 1</option>
                                            <option value="2">PRECIO 2</option>
                                            <option value="3">PRECIO 3</option>
                                        </select>
                                    </div>
                                    <div class="col-md-4">
                                        <label for="vendedor" class="form-label">Vendedor</label>
                                        <select class="form-select" id="vendedor" name="vendedor">
                                            <option value="">Seleccione...</option>
                                        </select>
                                    </div>
                                </div>
                                
                                <div class="row mb-3">
                                    <div class="col-12">
                                        <label for="observa" class="form-label">Observaciones</label>
                                        <textarea class="form-control" id="observa" name="observa" rows="3"><?= old('observa') ?></textarea>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Pestaña de Datos Financieros -->
                            <div class="tab_content" id="financieros">
                                <div class="row mb-3">
                                    <div class="col-md-4">
                                        <div class="form-check mt-4">
                                            <input class="form-check-input" type="checkbox" id="escredito" name="escredito" value="1">
                                            <label class="form-check-label" for="escredito">Es Crédito</label>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <label for="limitecred" class="form-label">Límite Crédito</label>
                                        <input type="number" class="form-control" id="limitecred" name="limitecred" value="<?= old('limitecred', '0.00') ?>" step="0.01">
                                    </div>
                                    <div class="col-md-4">
                                        <label for="diascred" class="form-label">Días Crédito</label>
                                        <input type="number" class="form-control" id="diascred" name="diascred" value="<?= old('diascred', '0') ?>">
                                    </div>
                                </div>
                                
                                <div class="row mb-3">
                                    <div class="col-md-4">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="estoleran" name="estoleran" value="1">
                                            <label class="form-check-label" for="estoleran">Es Tolerancia</label>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <label for="diastole" class="form-label">Días Tolerancia</label>
                                        <input type="number" class="form-control" id="diastole" name="diastole" value="<?= old('diastole', '0') ?>">
                                    </div>
                                    <div class="col-md-4">
                                        <label for="intmora" class="form-label">Interés Mora (%)</label>
                                        <input type="number" class="form-control" id="intmora" name="intmora" value="<?= old('intmora', '0.00') ?>" step="0.01">
                                    </div>
                                </div>
                                
                                <div class="row mb-3">
                                    <div class="col-md-4">
                                        <label for="descto" class="form-label">Descuento (%)</label>
                                        <input type="number" class="form-control" id="descto" name="descto" value="<?= old('descto', '0.00') ?>" step="0.01">
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-check mt-4">
                                            <input class="form-check-input" type="checkbox" id="esreten" name="esreten" value="1">
                                            <label class="form-check-label" for="esreten">Es Retención</label>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <label for="reteniva" class="form-label">Retención IVA (%)</label>
                                        <input type="number" class="form-control" id="reteniva" name="reteniva" value="<?= old('reteniva', '0.00') ?>" step="0.01">
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="d-grid gap-2 d-md-flex justify-content-md-end mt-4">
                            <button type="reset" class="btn btn-secondary">Cancelar</button>
                            <button type="submit" class="btn btn-primary">Guardar Cliente</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('scripts') ?>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
<script>
    $(document).ready(function() {
        
        // ===== TABS FUNCTIONALITY =====
        $('.tab_link').on('click', function(e) {
            e.preventDefault();
            
            const targetTab = $(this).data('tab');
            
            // Remove active class from all tabs and content
            $('.tab_link').removeClass('active');
            $('.tab_content').removeClass('active');
            
            // Add active class to clicked tab and corresponding content
            $(this).addClass('active');
            $('#' + targetTab).addClass('active');
        });
        
        // ===== CONSULTA SII FUNCTIONALITY =====
        $('#consultarSII').on('click', function() {
            const rut = $('#id3').val().trim();
            
            if (!rut) {
                Swal.fire({
                    icon: 'warning',
                    title: 'RUT requerido',
                    text: 'Por favor ingrese un RUT antes de consultar.',
                    toast: true,
                    position: 'top-end',
                    showConfirmButton: false,
                    timer: 3000
                });
                return;
            }
            
            // Validación básica de formato RUT
            // if (!validarFormatoRUT(rut)) {
            //     Swal.fire({
            //         icon: 'error',
            //         title: 'RUT inválido',
            //         text: 'El formato del RUT no es válido. Ejemplo: 77105708-K',
            //         toast: true,
            //         position: 'top-end',
            //         showConfirmButton: false,
            //         timer: 4000
            //     });
            //     return;
            // }
            
            // Realizar consulta con reintentos
            consultarSIIConReintentos(rut);
        });
        
        // Función para consultar SII con reintentos
        function consultarSIIConReintentos(rut, intento = 1, maxIntentos = 4) {
            const esPrimerIntento = intento === 1;
            
            if (esPrimerIntento) {
                // Mostrar spinner solo en el primer intento
                $('#siiSpinner').removeClass('d-none');
                $('#consultarSII').prop('disabled', true).html('<i class="fas fa-spinner fa-spin"></i> Consultando...');
            } else {
                // Actualizar botón con número de intento
                $('#consultarSII').html(`<i class="fas fa-spinner fa-spin"></i> Intento ${intento}/${maxIntentos}...`);
            }
            
            $.ajax({
                url: 'http://3.69.230.135:8001/consultar/' + encodeURIComponent(rut),
                method: 'GET',
                timeout: 15000, // Timeout más corto para permitir reintentos
                cache: false,
                headers: {
                    'Cache-Control': 'no-cache',
                    'Pragma': 'no-cache'
                },
                success: function(response) {
                    if (response && response.rut) {
                        // Llenar campos con la información obtenida
                        llenarDatosSII(response);
                        
                        Swal.fire({
                            icon: 'success',
                            title: 'Datos obtenidos',
                            text: `Información del SII cargada exitosamente${intento > 1 ? ` (intento ${intento})` : ''}.`,
                            toast: true,
                            position: 'top-end',
                            showConfirmButton: false,
                            timer: 3000
                        });
                        
                        // Restaurar estado original
                        restaurarBotonSII();
                    } else {
                        throw new Error('Respuesta inválida del servidor');
                    }
                },
                error: function(xhr, status, error) {
                    console.log(`Intento ${intento} fallido:`, status, error, xhr.status);
                    
                    // Si no es el último intento y el error puede ser temporal, reintentar
                    if (intento < maxIntentos && puedeReintentar(xhr.status, status)) {
                        // Esperar un poco antes del siguiente intento (backoff exponencial)
                        const delay = Math.pow(2, intento - 1) * 1000; // 1s, 2s, 4s
                        
                        setTimeout(() => {
                            consultarSIIConReintentos(rut, intento + 1, maxIntentos);
                        }, delay);
                        
                    } else {
                        // Ya no hay más intentos o error no recuperable
                        let mensaje = 'Error al consultar SII: ';
                        
                        if (status === 'timeout') {
                            mensaje += 'Tiempo de espera agotado';
                        } else if (xhr.status === 400) {
                            mensaje += 'RUT inválido';
                        } else if (xhr.status === 404) {
                            mensaje += 'RUT no encontrado en SII';
                        } else if (xhr.status === 503) {
                            mensaje += 'Servicio SII temporalmente no disponible';
                        } else if (xhr.status === 0) {
                            mensaje += 'No se puede conectar al servicio';
                        } else {
                            mensaje += 'Servicio no disponible';
                        }
                        
                        if (intento > 1) {
                            mensaje += ` (intentos realizados: ${intento})`;
                        }
                        
                        Swal.fire({
                            icon: 'error',
                            title: 'Error de consulta',
                            text: mensaje,
                            toast: true,
                            position: 'top-end',
                            showConfirmButton: false,
                            timer: 6000
                        });
                        
                        restaurarBotonSII();
                    }
                }
            });
        }
        
        // Función para determinar si se puede reintentar según el tipo de error
        function puedeReintentar(httpStatus, ajaxStatus) {
            // No reintentar en errores de cliente (400-499) excepto algunos específicos
            if (httpStatus >= 400 && httpStatus < 500) {
                // Solo reintentar en algunos errores 4xx que pueden ser temporales
                return httpStatus === 408 || httpStatus === 429; // Request Timeout, Too Many Requests
            }
            
            // Reintentar en errores de servidor (500-599)
            if (httpStatus >= 500) {
                return true;
            }
            
            // Reintentar en errores de conexión/timeout
            if (ajaxStatus === 'timeout' || ajaxStatus === 'error' || httpStatus === 0) {
                return true;
            }
            
            return false;
        }
        
        // Función para restaurar el estado original del botón
        function restaurarBotonSII() {
            $('#siiSpinner').addClass('d-none');
            $('#consultarSII').prop('disabled', false).html('<i class="fas fa-search"></i> SII');
        }
        
        // Función para llenar datos desde SII
        function llenarDatosSII(data) {
            if (data.razon_social) {
                $('#descrip').val(data.razon_social);
            }
            
            // Seleccionar Chile automáticamente
            $('#pais option').each(function() {
                if ($(this).text().toLowerCase().includes('chile')) {
                    $(this).prop('selected', true);
                    $('#pais').trigger('change');
                    
                    // Esperar un momento y seleccionar Santiago
                    setTimeout(function() {
                        $('#estado option').each(function() {
                            if ($(this).text().toLowerCase().includes('santiago')) {
                                $(this).prop('selected', true);
                                $('#estado').trigger('change');
                                return false;
                            }
                        });
                    }, 1000);
                    
                    return false;
                }
            });
            
            // Si hay email en los datos
            if (data.email) {
                $('#email').val(data.email);
            }
            
            // Si hay fecha de inicio de actividades
            if (data.fecha_inicio_actividades) {
                // Convertir formato de fecha si es necesario
                const fecha = convertirFecha(data.fecha_inicio_actividades);
                if (fecha) {
                    $('#fechae').val(fecha);
                }
            }
            
            // Agregar actividades económicas a observaciones si existen
            if (data.actividades_economicas && data.actividades_economicas.length > 0) {
                let observaciones = $('#observa').val();
                observaciones += observaciones ? '\n\n' : '';
                observaciones += 'Actividades económicas SII:\n';
                
                data.actividades_economicas.forEach(function(actividad, index) {
                    observaciones += `${index + 1}. ${actividad.descripcion} (Código: ${actividad.codigo})\n`;
                });
                
                $('#observa').val(observaciones);
            }
        }
        
        // Función para validar formato básico del RUT
        function validarFormatoRUT(rut) {
            // Patrón básico: números, opcionalmente puntos, guión y dígito verificador
            const patron = /^[0-9]+(\.?[0-9]+)*-[0-9kK]$/;
            return patron.test(rut);
        }
        
        // Función para convertir fecha DD-MM-YYYY a YYYY-MM-DD
        function convertirFecha(fechaStr) {
            if (!fechaStr) return null;
            
            const partes = fechaStr.split('-');
            if (partes.length === 3) {
                // Asumiendo formato DD-MM-YYYY
                const dia = partes[0].padStart(2, '0');
                const mes = partes[1].padStart(2, '0');
                const año = partes[2];
                
                return `${año}-${mes}-${dia}`;
            }
            
            return null;
        }
        
        // ===== UBICACIÓN GEOGRÁFICA (tu código existente) =====
        $('#pais').on('change', function() {
            const paisId = $(this).val();
            const estadoSelect = $('#estado');
            const ciudadSelect = $('#ciudad');
            const municipioSelect = $('#municipio');
            const estadoSpinner = $('#estadoSpinner');
            
            // Limpiar selects dependientes
            ciudadSelect.html('<option value="">Seleccione primero un estado</option>').prop('disabled', true);
            municipioSelect.html('<option value="">Seleccione primero una ciudad</option>').prop('disabled', true);
            
            if (paisId) {
                estadoSpinner.removeClass('d-none');
                estadoSelect.html('<option value="">Cargando...</option>').prop('disabled', true);
                
                $.ajax({
                    url: '<?= base_url('clientes/getEstados') ?>',
                    type: 'POST',
                    data: { pais_id: paisId },
                    dataType: 'json',
                    success: function(estados) {
                        estadoSelect.html('<option value="">Seleccione un estado</option>');
                        
                        if (Array.isArray(estados) && estados.length > 0) {
                            $.each(estados, function(index, estado) {
                                const selected = '<?= old('estado') ?>' == estado.Estado ? 'selected' : '';
                                estadoSelect.append(`<option value="${estado.Estado}" ${selected}>${estado.Descrip}</option>`);
                            });
                            estadoSelect.prop('disabled', false);
                            
                            if ('<?= old('estado') ?>') {
                                estadoSelect.trigger('change');
                            }
                        } else {
                            estadoSelect.html('<option value="">No hay estados disponibles</option>');
                        }
                    },
                    error: function() {
                        estadoSelect.html('<option value="">Error al cargar estados</option>');
                        mostrarToast('Error al cargar estados', 'error');
                    },
                    complete: function() {
                        estadoSpinner.addClass('d-none');
                    }
                });
            } else {
                estadoSelect.html('<option value="">Seleccione primero un país</option>').prop('disabled', true);
            }
        });
        
        // [Resto del código de ubicación geográfica...]
        $('#estado').on('change', function() {
            const estadoId = $(this).val();
            const ciudadSelect = $('#ciudad');
            const municipioSelect = $('#municipio');
            const ciudadSpinner = $('#ciudadSpinner');
            
            municipioSelect.html('<option value="">Seleccione primero una ciudad</option>').prop('disabled', true);
            
            if (estadoId) {
                ciudadSpinner.removeClass('d-none');
                ciudadSelect.html('<option value="">Cargando...</option>').prop('disabled', true);
                
                $.ajax({
                    url: '<?= base_url('clientes/getCiudades') ?>',
                    type: 'POST',
                    data: { estado_id: estadoId },
                    dataType: 'json',
                    success: function(ciudades) {
                        ciudadSelect.html('<option value="">Seleccione una ciudad</option>');
                        
                        if (Array.isArray(ciudades) && ciudades.length > 0) {
                            $.each(ciudades, function(index, ciudad) {
                                const selected = '<?= old('ciudad') ?>' == ciudad.Ciudad ? 'selected' : '';
                                ciudadSelect.append(`<option value="${ciudad.Ciudad}" ${selected}>${ciudad.Descrip}</option>`);
                            });
                            ciudadSelect.prop('disabled', false);
                        } else {
                            ciudadSelect.html('<option value="">No hay ciudades disponibles</option>');
                        }
                    },
                    error: function() {
                        ciudadSelect.html('<option value="">Error al cargar ciudades</option>');
                        Swal.fire({
                            toast: true,
                            position: 'top-end',
                            icon: 'error',
                            title: 'Error al cargar ciudades',
                            showConfirmButton: false,
                            timer: 3000
                        });
                    },
                    complete: function() {
                        ciudadSpinner.addClass('d-none');
                    }
                });
            } else {
                ciudadSelect.html('<option value="">Seleccione primero un estado</option>').prop('disabled', true);
            }
        });
        
        // [Resto del código existente para municipios, checkboxes, etc.]
        $('#ciudad').on('change', function() {
            const ciudadId = $(this).val();
            const municipioSelect = $('#municipio');
            const municipioSpinner = $('#municipioSpinner');
            
            if (ciudadId) {
                municipioSpinner.removeClass('d-none');
                municipioSelect.html('<option value="">Cargando...</option>').prop('disabled', true);
                
                $.ajax({
                    url: '<?= base_url('clientes/getMunicipios') ?>',
                    type: 'POST',
                    data: { ciudad_id: ciudadId },
                    dataType: 'json',
                    success: function(municipios) {
                        municipioSelect.html('<option value="">Seleccione un municipio</option>');
                        
                        if (Array.isArray(municipios) && municipios.length > 0) {
                            $.each(municipios, function(index, municipio) {
                                const selected = '<?= old('municipio') ?>' == municipio.Municipio ? 'selected' : '';
                                municipioSelect.append(`<option value="${municipio.Municipio}" ${selected}>${municipio.Descrip}</option>`);
                            });
                            municipioSelect.prop('disabled', false);
                        } else {
                            municipioSelect.html('<option value="">No hay municipios disponibles</option>');
                        }
                    },
                    error: function() {
                        municipioSelect.html('<option value="">Error al cargar municipios</option>');
                    },
                    complete: function() {
                        municipioSpinner.addClass('d-none');
                    }
                });
            } else {
                municipioSelect.html('<option value="">Seleccione primero una ciudad</option>').prop('disabled', true);
            }
        });
        
        // Cargar datos guardados en caso de error de validación
        <?php if (old('pais')): ?>
            <?php if (old('estado')): ?>
                $('#estado').prop('disabled', false);
                $('#estado').trigger('change');
            <?php endif; ?>
        <?php endif; ?>

        // Función auxiliar para mostrar toast
        function mostrarToast(mensaje, tipo = 'info') {
            if (typeof Swal !== 'undefined') {
                Swal.fire({
                    toast: true,
                    position: 'top-end',
                    icon: tipo,
                    title: mensaje,
                    showConfirmButton: false,
                    timer: 3000
                });
            } else {
                alert(mensaje);
            }
        }
        
        // Habilitar/deshabilitar campos de crédito según checkbox
        $('#escredito').on('change', function() {
            const habilitado = $(this).is(':checked');
            $('#limitecred, #diascred').prop('disabled', !habilitado);
        });
        
        // Habilitar/deshabilitar campos de tolerancia según checkbox
        $('#estoleran').on('change', function() {
            const habilitado = $(this).is(':checked');
            $('#diastole').prop('disabled', !habilitado);
        });
        
        // Inicializar estados de los campos
        $('#limitecred, #diascred').prop('disabled', !$('#escredito').is(':checked'));
        $('#diastole').prop('disabled', !$('#estoleran').is(':checked'));
    });
</script>
<?= $this->endSection() ?>
<!-- CSS adicional para las tabs -->
<style>


#consultarSII {
    white-space: nowrap;
}


/* Button states */
#consultarSII:disabled {
    opacity: 0.65;
    cursor: not-allowed;
}
</style>