<?php

namespace App\Models;

use CodeIgniter\Model;

class ProductosModel extends Model
{
    protected $table = 'SAPROD';
    protected $primaryKey = 'CodProd';
    protected $allowedFields = ['CodProd', 'Descrip', 'Activo'];

    public function buscarProductos($filtro, $bodega)
    {
        $db = \Config\Database::connect();

        // Consulta principal a SAPROD
        // $builder = $db->table('SAPROD p')
        //     ->select('p.CodProd, p.Descrip, e.Existen, e.PuestoI')
        //     ->join('SAEXIS e', 'p.CodProd = e.CodProd', 'left')
        //     ->where('p.Activo', '1')
        //     ->where('e.CodUbic', $bodega)
        //     ->like('p.CodProd', $filtro);

        $builder = $db->table('SAPROD p')
            ->select('p.CodProd, p.Descrip, p.Refere, e.Existen, e.PuestoI')
            ->join('SAEXIS e', 'p.CodProd = e.CodProd', 'left')
            ->where('p.Activo', '1')
            ->where('e.CodUbic', $bodega)
            ->groupStart()
                ->like('p.CodProd', $filtro)
                ->orLike('p.Descrip', $filtro)
                ->orLike('p.Refere', $filtro)
            ->groupEnd();

        return $builder->get()->getResultArray();
    }

    public function getProductoDetalle($codProd, $bodega)
    {
        $db = \Config\Database::connect();

        return $db->table('SAPROD p')
            ->select('p.CodProd, p.Descrip, e.Existen, e.PuestoI, e.CodUbic')
            ->join('SAEXIS e', 'p.CodProd = e.CodProd', 'left')
            ->where('p.CodProd', $codProd)
            ->where('e.CodUbic', $bodega)
            ->get()
            ->getRowArray();
    }

    public function actualizarUbicacion($codProd, $bodega, $nuevaPosicion)
    {
        $db = \Config\Database::connect();

        return $db->table('SAEXIS')
            ->where('CodProd', $codProd)
            ->where('CodUbic', $bodega)
            ->update(['PuestoI' => $nuevaPosicion]);
    }

    // public function getProductoConExistencia($codProd)
    // {
    //     $db = \Config\Database::connect();
    //     return $db->table('SAPROD p')
    //              ->select('p.CodProd, p.Descrip, SUM(e.Existen) as Existen')
    //              ->join('SAEXIS e', 'p.CodProd = e.CodProd', 'left')
    //              ->where('p.Activo', '1')
    //              ->where('p.CodProd', $codProd)
    //              ->groupBy('p.CodProd, p.Descrip')
    //              ->get()
    //              ->getRowArray();
    // }

    public function getProductoConExistencia($codProd) {
        $db = \Config\Database::connect();
        
        // Si el código contiene separadores, dividirlo
        //$codigos = preg_split('/[\s\/,\-]+/', $codProd);
        //$codigos = array_map('trim', $codigos);
        
        $stocks = [];
        //foreach ($codigos as $codigo) {
            $result = $db->table('SAPROD p')
                ->select('p.Descrip2 as CodProd, p.Descrip, SUM(e.Existen) as Existen, p.Precio3')
                ->join('SAEXIS e', 'p.CodProd = e.CodProd', 'left')
                ->where('p.Activo', '1')
                ->where('p.Descrip2', $codProd)
                ->groupBy('p.Descrip2, p.Descrip, p.Precio3')
                ->get()
                ->getRowArray();
                
            if ($result) {
                $stocks[] = [
                    'CodProd' => $codProd,
                    'Precio3' => $result['Precio3'],
                    'Existen' => (int) $result['Existen'],
                    'Descrip' => $result['Descrip']
                ];
            }
        //}
        
        // Encontrar el producto con menor stock
        // $minStock = array_reduce($stocks, function($carry, $item) {
        //     if ($carry === null || $item['Existen'] < $carry['Existen']) {
        //         return $item;
        //     }
        //     return $carry;
        // });
        
        // return $minStock ?: null;
        return $result;
    }

    public function getProductosConExistenciaPaginado($start = 0, $length = 10, $search = '', $orderColumn = 'CodProd', $orderDir = 'ASC')
    {

        $ch = curl_init(base_url('mercadolibre/listarProductosML'));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $mlResponse = curl_exec($ch);
        curl_close($ch);
        
        $mlData = json_decode($mlResponse, true);
        
        if (!$mlData['success']) {
            throw new \Exception("Error al obtener productos de MercadoLibre");
        }

        $mlSkus = array_map(function($item) {
            return $item['skuv'];
        }, $mlData['items']);

        $mlSkus = array_filter($mlSkus);

        $db = \Config\Database::connect();

        $builder = $db->table('SAPROD p')
                     ->select('p.CodProd, p.Descrip, 
                              SUM(e.Existen) as Existen, 
                              STRING_AGG(e.CodUbic, \',\') as CodUbic, 
                              ml.ml_id, ml.cod_prod, ml.ultimo_sync, p.Precio3 as Precio3')
                     ->join('SAEXIS e', 'p.CodProd = e.CodProd', 'left')
                     ->join('ml_productos_sync ml', 'p.CodProd = ml.cod_prod', 'left')
                     ->where('p.Activo', '1')
                     ->whereIn('p.CodProd', $mlSkus)
                     ->groupBy('p.CodProd, p.Descrip, ml.ml_id, ml.cod_prod, ml.ultimo_sync, p.Precio3');
        //$builder = $db->table('SAPROD p')
        //             ->select('p.CodProd, p.Descrip, e.Existen, e.CodUbic, ml.ml_id, ml.cod_prod, ml.ultimo_sync')
        //             ->join('SAEXIS e', 'p.CodProd = e.CodProd', 'left')
        //             ->join('ml_productos_sync ml', 'p.CodProd = ml.cod_prod', 'left')
        //             ->where('p.Activo', '1');

        // Aplicar búsqueda si existe
        if (!empty($search)) {
            $builder->groupStart()
                   ->like('p.CodProd', $search)
                   ->orLike('p.Descrip', $search)
                   ->groupEnd();
        }

        // Obtener total de registros filtrados
        $totalFiltered = $builder->countAllResults(false);

        // Aplicar ordenamiento y paginación
        $builder->orderBy($orderColumn, $orderDir)
                ->limit($length, $start);

        // Obtener los datos
        $results = $builder->get()->getResultArray();

        // Agregar información adicional de ML a cada producto
        foreach ($results as &$result) {
            foreach ($mlData['items'] as $mlItem) {
                if (($mlItem['sku'] === $result['CodProd'] || $mlItem['skuv'] === $result['CodProd']) && isset($mlItem['id'])) {
                    $result['ml_id'] = $mlItem['id'];
                    $result['ml_title'] = $mlItem['title'];
                    $result['ml_price'] = $mlItem['price'];
                    $result['ml_quantity'] = $mlItem['available_quantity'];
                    $result['ml_status'] = $mlItem['status'];
                    $result['ml_permalink'] = $mlItem['permalink'];
                    break;
                }
            }
        }

        return [
            'data' => $results,
            'recordsFiltered' => $totalFiltered,
            'recordsTotal' => count($mlSkus)
        ];
    }

}