<?= $this->extend('layouts/main') ?>

<?= $this->section('title') ?>
Buscador de Productos
<?= $this->endSection() ?>

<?= $this->section('page_title') ?>
BUSCADOR DE PRODUCTOS
<?= $this->endSection() ?>

<?= $this->section('content') ?>
<div class="mb-3">
    <div class="sign__content">
        <form class="login" method="post">
            <div class="form__content">
                <div class="form__username">
                    <label for="bodega">Bodega</label>
                    <select name="bodega" id="bodega">
                        <?php foreach ($bodegas as $bodega): ?>
                            <option value="<?= esc($bodega['CodUbic']) ?>"><?= esc($bodega['CodUbic']) ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <input type="text" id="searchInput" placeholder="Buscar Codigo de Producto...">
                <ul id="searchResults"></ul>
            </div>
        </form>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const searchInput = document.getElementById('searchInput');
    const bodegaSelect = document.getElementById('bodega');

    searchInput.focus();

    searchInput.addEventListener('input', function() {
        const searchTerm = this.value;
        if (searchTerm.length > 0) {
            buscarProductos(searchTerm);
        } else {
            document.getElementById('searchResults').innerHTML = '';
        }
    });

    function buscarProductos(term) {
        const bodega = bodegaSelect.value;
        $.ajax({
            url: `<?= base_url('productos/buscar') ?>`,
            method: 'GET',
            data: { 
                filtro: term, 
                bodega: bodega 
            },
            success: function(response) {
                console.log(response);
                mostrarResultados(response);
            },
            error: function(xhr, status, error) {
                console.error('Error al buscar productos:', error);
            }
        });
    }

    function mostrarResultados(resultados) {
        const listaResultados = document.getElementById('searchResults');
        listaResultados.innerHTML = '';

        resultados.forEach(resultado => {
            const li = document.createElement('li');
            li.style.backgroundColor = '#EFF143';
            li.style.color = 'black';
            li.style.padding = '10px';
            li.style.marginBottom = '10px';

            li.innerHTML = `
                <strong>Nombre:</strong> ${resultado.Descrip}<br>
                <strong>Ubicación:</strong> ${resultado.PuestoI}<br>
                <strong>Stock:</strong> ${resultado.Existen}<br>
                <strong>SKU:</strong> ${resultado.CodProd}<br>
                <a target="_blank" href="<?= base_url('edit') ?>?id=${resultado.CodProd}&bodega=${bodegaSelect.value}">Ver</a>
            `;

            listaResultados.appendChild(li);
        });
    }
});
</script>
<?= $this->endSection() ?>