<?= $this->extend('layouts/main') ?>

<?= $this->section('content') ?>
<div class="techwave_fn_user_billing_page">
    <div class="container small">
        <!-- Database Configuration -->
        <div class="user__billing">
            <div class="billing__info">
                <div class="info__content">
                    <div class="fn__title_holder">
                        <h3>Configuración Base de Datos</h3>
                    </div>

                    <form id="dbConfigForm" class="fn__form">
                        <div class="fn__form_item">
                            <label>Hostname:</label>
                            <input type="text" name="hostname"
                                value="<?= esc($db_config['hostname']['valor'] ?? '') ?>">
                        </div>
                        <div class="fn__form_item">
                            <label>Username:</label>
                            <input type="text" name="username"
                                value="<?= esc($db_config['username']['valor'] ?? '') ?>">
                        </div>
                        <div class="fn__form_item">
                            <label>Password:</label>
                            <input type="password" name="password"
                                value="<?= esc($db_config['password']['valor'] ?? '') ?>">
                        </div>
                        <div class="fn__form_item">
                            <label>Database:</label>
                            <input type="text" name="database"
                                value="<?= esc($db_config['database']['valor'] ?? '') ?>">
                        </div>
                        <button type="submit" class="techwave_fn_button">
                            <span>Guardar Configuración DB</span>
                        </button>
                    </form>
                </div>
            </div>
        </div>

        <!-- MercadoLibre Configuration -->
        <div class="user__billing mt-4">
            <div class="billing__info">
                <div class="info__content">
                    <div class="fn__title_holder">
                        <h3>Configuración MercadoLibre</h3>
                    </div>

                    <form id="mlConfigForm" class="fn__form">
                        <div class="fn__form_item">
                            <label>Client ID:</label>
                            <input type="text" name="client_id"
                                value="<?= esc($ml_config['client_id']['valor'] ?? '') ?>">
                        </div>
                        <div class="fn__form_item">
                            <label>Client Secret:</label>
                            <input type="password" name="client_secret"
                                value="<?= esc($ml_config['client_secret']['valor'] ?? '') ?>">
                        </div>
                        <div class="fn__form_item">
                            <label>Access Token:</label>
                            <input type="text" name="access_token"
                                value="<?= esc($ml_config['access_token']['valor'] ?? '') ?>" readonly>
                        </div>
                        <div class="fn__form_item">
                            <label>Refresh Token:</label>
                            <input type="text" name="refresh_token"
                                value="<?= esc($ml_config['refresh_token']['valor'] ?? '') ?>" readonly>
                        </div>
                        <button type="submit" class="techwave_fn_button">
                            <span>Guardar Configuración ML</span>
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        // Database Config Form
        document.getElementById('dbConfigForm').addEventListener('submit', function (e) {
            e.preventDefault();
            const formData = new FormData(document.getElementById('dbConfigForm'));

            $.ajax({
                url: '<?= base_url('config/guardarDB') ?>',
                method: 'POST',
                data: {
                    hostname: formData.get('hostname'),
                    username: formData.get('username'),
                    password: formData.get('password'),
                    database: formData.get('database')
                },
                success: function (response) {
                    alert(response.message);
                },
                error: function (xhr, status, error) {
                    alert('Error al probar la conexión: ' + error);
                }
            });
        });

        // MercadoLibre Config Form
        document.getElementById('mlConfigForm').addEventListener('submit', function (e) {
            e.preventDefault();
            saveConfig('ml', this);
        });

        function saveConfig(tipo, form) {
            const formData = new FormData(form);
            const datos = {};
            for (let [key, value] of formData.entries()) {
                datos[key] = value;
            }

            $.ajax({
                url: '<?= base_url('config/guardar') ?>',
                method: 'POST',
                data: {
                    tipo: tipo,
                    datos: datos
                },
                success: function (response) {
                    if (response.success) {
                        alert('Configuración guardada correctamente');
                    } else {
                        alert('Error: ' + response.message);
                    }
                },
                error: function (xhr, status, error) {
                    alert('Error al guardar la configuración: ' + error);
                }
            });
        }
    });
</script>
<?= $this->endSection() ?>