<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Cotización #<?= $cotizacion['NumeroD'] ?></title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            line-height: 1.4;
            margin: 0;
            padding: 0;
        }
        .container {
            width: 100%;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
        }
        .header h1 {
            margin: 0;
            color: #333;
            font-size: 24px;
        }
        .info-boxes {
            width: 100%;
            margin-bottom: 20px;
        }
        .box {
            border: 1px solid #ccc;
            padding: 10px;
            margin-bottom: 10px;
        }
        .box h2 {
            margin: 0 0 10px 0;
            font-size: 16px;
            padding-bottom: 5px;
            border-bottom: 1px solid #ddd;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        table th, table td {
            padding: 8px;
            text-align: left;
            border-bottom: 1px solid #ddd;
        }
        table th {
            background-color: #f2f2f2;
        }
        .totals {
            width: 50%;
            float: right;
        }
        .totals table {
            width: 100%;
        }
        .totals table th {
            text-align: right;
        }
        .totals table td {
            text-align: right;
        }
        .footer {
            margin-top: 50px;
            text-align: center;
            font-size: 11px;
            color: #777;
        }
        .clearfix:after {
            content: "";
            display: table;
            clear: both;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1><?= $empresa['nombre'] ?></h1>
            <p><?= $empresa['direccion'] ?></p>
            <p>Tel: <?= $empresa['telefono'] ?> | RIF: <?= $empresa['nit'] ?></p>
            <h2>COTIZACIÓN N° <?= $cotizacion['NumeroD'] ?></h2>
        </div>
        
        <div class="info-boxes clearfix">
            <div class="box" style="width: 45%; float: left;">
                <h2>Cliente</h2>
                <p><strong>Nombre:</strong> <?= $cotizacion['NombreCliente'] ?></p>
                <p><strong>Identificación:</strong> <?= $cotizacion['ClienteID'] ?></p>
                <p><strong>Dirección:</strong> <?= $cotizacion['Direc1'] ?? '-' ?></p>
                <p><strong>Teléfono:</strong> <?= $cotizacion['Telef'] ?? '-' ?></p>
            </div>
            
            <div class="box" style="width: 45%; float: right;">
                <h2>Información de la Cotización</h2>
                <p><strong>Fecha:</strong> <?= date('d/m/Y', strtotime($cotizacion['FechaE'])) ?></p>
                <p><strong>Válida hasta:</strong> <?= date('d/m/Y', strtotime($cotizacion['FechaV'])) ?></p>
                <p><strong>Moneda:</strong> <?= $cotizacion['Moneda'] ?></p>
            </div>
        </div>
        
        <?php if (!empty($cotizacion['Notas1'])): ?>
        <div class="box">
            <h2>Notas</h2>
            <p><?= $cotizacion['Notas1'] ?></p>
        </div>
        <?php endif; ?>
        
        <table>
            <thead>
                <tr>
                    <th>Código</th>
                    <th>Descripción</th>
                    <th>Cantidad</th>
                    <th>Precio Unit.</th>
                    <th>Subtotal</th>
                    <th>IVA</th>
                    <th>Total</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($detalles as $detalle): ?>
                <tr>
                    <td><?= $detalle['CodItem'] ?></td>
                    <td><?= $detalle['Descrip1'] ?></td>
                    <td><?= $detalle['Cantidad'] ?></td>
                    <td><?= number_format($detalle['Precio'], 2) ?></td>
                    <td><?= number_format($detalle['Cantidad'] * $detalle['Precio'], 2) ?></td>
                    <td><?= number_format($detalle['MtoTax'], 2) ?></td>
                    <td><?= number_format($detalle['TotalItem'], 2) ?></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        
        <div class="totals">
            <table>
                <tr>
                    <th>Subtotal:</th>
                    <td><?= number_format($cotizacion['TGravable'], 2) ?></td>
                </tr>
                <tr>
                    <th>IVA (16%):</th>
                    <td><?= number_format($cotizacion['MtoTax'], 2) ?></td>
                </tr>
                <tr>
                    <th>Total:</th>
                    <td><strong><?= number_format($cotizacion['MtoTotal'], 2) ?></strong></td>
                </tr>
            </table>
        </div>
        
        <div class="footer">
            <p>Gracias por su preferencia!</p>
        </div>
    </div>
</body>
</html>