<?php

namespace App\Models;

use CodeIgniter\Model;

class UserModel extends Model
{
    protected $table = 'users';
    protected $primaryKey = 'id';
    protected $useAutoIncrement = true;
    protected $returnType = 'array';
    protected $useSoftDeletes = false;
    protected $allowedFields = [
        'username', 
        'password',
        'menu_buscador',
        'menu_cotizaciones',
        'menu_facturacion',
        'menu_despachos',
        'menu_jumpseller', 
        'menu_clientes',
        'menu_mercadolibre',
        'menu_ordenes_ml',
        'menu_ordenes_venta',
        'menu_configuracion'
    ];
    protected $useTimestamps = true;
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';

    // Método para obtener los menús habilitados de un usuario
    public function getUserMenus($userId)
    {
        $user = $this->find($userId);
        if (!$user) return [];
        
        $menus = [];
        if ($user['menu_buscador']) $menus[] = 'buscador';
        if ($user['menu_cotizaciones']) $menus[] = 'cotizaciones';
        if ($user['menu_facturacion']) $menus[] = 'facturacion';
        if ($user['menu_despachos']) $menus[] = 'despachos';
        if ($user['menu_jumpseller']) $menus[] = 'jumpseller';
        if ($user['menu_clientes']) $menus[] = 'clientes';
        if ($user['menu_mercadolibre']) $menus[] = 'mercadolibre';
        if ($user['menu_ordenes_ml']) $menus[] = 'ordenes_ml';
        if ($user['menu_ordenes_venta']) $menus[] = 'ordenes_venta';
        if ($user['menu_configuracion']) $menus[] = 'configuracion';
        
        return $menus;
    }

    
}