<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */

$routes->group('', ['filter' => 'auth'], function($routes) {
    $routes->get('/', 'Home::index');
    $routes->get('/config', 'Config::index');
    $routes->get('/edit', 'Home::edit');
    $routes->get('/mercadolibre', 'MercadoLibre::index');
    $routes->get('mercadolibre_orders', 'MercadoLibreOrders::index');
    $routes->get('mercadolibre_orders/detalleOrden/(:segment)', 'MercadoLibreOrders::detalleOrden/$1');
    $routes->get('/ordenes', 'Orders::index');
    $routes->get('ordenes/detalle/(:num)', 'Orders::detalle/$1');
    $routes->get('/despachos', 'Despachos::index');
    $routes->get('despachos/detalle/(:num)', 'Despachos::detalle/$1');
    $routes->get('/cotizaciones', 'Cotizaciones::index');
    $routes->get('/cotizaciones/listado', 'Cotizaciones::listado');
    $routes->get('/cotizaciones/ver/(:num)', 'Cotizaciones::ver/$1');
    $routes->get('/cotizaciones/pdf/(:num)', 'Cotizaciones::pdf/$1');
    $routes->get('/cotizaciones/convertir/(:num)', 'Cotizaciones::convertir/$1');
    $routes->get('/facturacion', 'Facturacion::index');
    $routes->get('/cotizaciones/listado_cotizaciones', 'Cotizaciones::listado_cotizaciones');
    $routes->get('/facturacion/listado', 'Facturacion::listado');
    $routes->get('/facturacion/ver/(:num)', 'Facturacion::ver/$1');
    $routes->get('/facturacion/pdf/(:num)', 'Facturacion::pdf/$1');
    // Otras rutas protegidas
});


$routes->group('archivos', function($routes) {
    
    // Dashboard principal de archivos
    $routes->get('/', 'Archivos::index');
    
    // Rutas para Clientes dentro de Archivos
    $routes->get('clientes', 'Archivos::clientes');
    $routes->get('clientes/crear', 'Archivos::crear_cliente');
    $routes->post('clientes/guardar', 'Archivos::guardar_cliente');
    $routes->get('clientes/ver/(:segment)', 'Archivos::ver_cliente/$1');
    $routes->get('clientes/editar/(:segment)', 'Archivos::editar_cliente/$1');
    $routes->post('clientes/actualizar/(:segment)', 'Archivos::actualizar_cliente/$1');
    $routes->get('clientes/eliminar/(:segment)', 'Archivos::eliminar_cliente/$1');
    
    // Rutas para otras secciones de archivos
    $routes->get('convenios', 'Archivos::convenios');
    $routes->get('servidores', 'Archivos::servidores');
    $routes->get('retenciones', 'Archivos::retenciones');
    $routes->get('finalizar', 'Archivos::finalizar');
});

// Rutas para Clientes
$routes->get('/clientes', 'Clientes::index');
$routes->get('/clientes/crear', 'Clientes::crear');
$routes->get('crearcliente', 'Clientes::crear');
$routes->post('/clientes/guardar', 'Clientes::guardar');
$routes->get('/clientes/editar/(:segment)', 'Clientes::editar/$1');
$routes->get('/clientes/ver/(:segment)', 'Clientes::ver/$1');

 // Rutas AJAX para ubicación geográfica
$routes->post('/clientes/getEstados', 'Clientes::getEstados');
$routes->post('/clientes/getCiudades', 'Clientes::getCiudades');
$routes->post('/clientes/getMunicipios', 'Clientes::getMunicipios');
$routes->post('verificarCodigo', 'Clientes::verificarCodigo');

//COTIZACIONES
$routes->post('/cotizaciones/crear', 'Cotizaciones::crear');
$routes->post('/facturacion/crear', 'Facturacion::crear');
$routes->post('/cotizaciones/buscar-productos', 'Cotizaciones::buscarProductos');
$routes->post('/cotizaciones/buscar-clientes', 'Cotizaciones::buscarClientes');
$routes->post('/cotizaciones/crear-cliente', 'Cotizaciones::crearCliente');
$routes->get('/cotizaciones/obtener-vendedores', 'Cotizaciones::obtenerVendedores');
// Home Controller

$routes->post('/config/guardar', 'Config::guardar');
$routes->post('config/guardarDB', 'Config::guardarDB');


$routes->post('mercadolibre/toggleSync', 'MercadoLibre::toggleSync');
$routes->post('mercadolibre/sincronizar', 'MercadoLibre::sincronizar');
$routes->post('mercadolibre/sincronizarProducto', 'MercadoLibre::sincronizarProducto');
$routes->post('mercadolibre/toggleProductSelection', 'MercadoLibre::toggleProductSelection');
$routes->get('mercadolibre/listarProductosML', 'MercadoLibre::listarProductosML');
$routes->get('mercadolibre/productos', 'MercadoLibre::productos');
$routes->get('productos/buscar', 'Home::buscar');
$routes->post('editar/guardar', 'Home::guardarEdicion');


$routes->get('ordenes/listar', 'Orders::listar');

$routes->post('ordenes/actualizar-producto', 'Orders::actualizarProducto');

$routes->get('despachos/listar', 'Despachos::listar');

$routes->post('despachos/actualizar-producto', 'Despachos::actualizarProducto');

$routes->post('despachos/completarDespacho', 'Despachos::completarDespacho');



//Controladores cron Jobs
$routes->get('cron/syncProducts', 'MercadoLibreCron::syncProducts');
$routes->get('cron/syncMercadoLibre', 'MercadoLibreCron::syncMercadoLibre');


// Auth Controllers

$routes->get('/auth/login', 'Auth::login');
$routes->get('/auth/register', 'Auth::register');

$routes->get('/auth/logout', 'Auth::logout');

$routes->post('/auth/Alogin', 'Auth::attemptLogin');
$routes->post('/auth/Aregister', 'Auth::attemptRegister');


// ordenes de mercadolubre


$routes->get('mercadolibre_orders/listarOrdenes', 'MercadoLibreOrders::listarOrdenes');
$routes->post('mercadolibre_orders/sincronizarOrdenes', 'MercadoLibreOrders::sincronizarOrdenes');

$routes->post('mercadolibre_orders/crearFactura', 'MercadoLibreOrders::crearFactura');

$routes->get('jumpseller', 'Jumpseller::index');
$routes->get('jumpseller/listado', 'Jumpseller::listado');

// API endpoints para AJAX
$routes->post('jumpseller/toggleSync', 'Jumpseller::toggleSync');
$routes->get('jumpseller/listarProductosJS', 'Jumpseller::listarProductosJS');
$routes->get('jumpseller/listarProductosJSb', 'Jumpseller::listarProductosJSb');
$routes->get('jumpseller/productos', 'Jumpseller::productos');
$routes->post('jumpseller/sincronizarProducto', 'Jumpseller::sincronizarProducto');
$routes->post('jumpseller/sincronizar', 'Jumpseller::sincronizar');
$routes->post('jumpseller/toggleProductSelection', 'Jumpseller::toggleProductSelection');
$routes->post('jumpseller/sincronizarProductoInterno', 'Jumpseller::sincronizarProductoInterno');
$routes->get('jumpseller/obtenerCola', 'Jumpseller::obtenerCola');
$routes->post('jumpseller/marcarProcesado', 'Jumpseller::marcarProcesado');
$routes->get('jumpseller/estadisticasCola', 'Jumpseller::estadisticasCola');

// Rutas adicionales para administración
$routes->group('jumpseller', function($routes) {
    $routes->get('dashboard', 'Jumpseller::dashboard');
    $routes->get('estadisticas', 'Jumpseller::estadisticas');
    $routes->post('configurar', 'Jumpseller::configurar');
    $routes->get('logs', 'Jumpseller::logs');
});