<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title><?= $this->renderSection('title') ?> - BitPattern</title>
    <meta name="description" content="The small framework with powerful features">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="shortcut icon" type="image/png" href="/ferretodo/favicon.ico">

    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Heebo:wght@100;200;300;400;500;600;700;800;900&family=Work+Sans:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">
    
    <!-- CSS -->
    <link rel="stylesheet" href="/ferretodo/css/plugins.css?ver=1.0.0">
    <link rel="stylesheet" href="/ferretodo/css/style.css?ver=1.0.0">
    <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <link href="/ferretodo/new/vendor/datatables/css/jquery.dataTables.min.css" rel="stylesheet">

    <!-- React y ReactDOM -->
    <script src="https://unpkg.com/react@18/umd/react.development.js"></script>
    <script src="https://unpkg.com/react-dom@18/umd/react-dom.development.js"></script>
    
    <!-- Babel para JSX (en desarrollo) -->
    <script src="https://unpkg.com/babel-standalone@6/babel.min.js"></script>

    <!-- Additional CSS -->
    <?= $this->renderSection('css') ?>
</head>
<body>
    <!-- Sidebar -->

    <!-- CONTENT -->
    <div class="techwave_fn_content">
        <!-- PAGE -->
        <div class="techwave_fn_page">
            <!-- Page Title -->
            <div class="techwave_fn_pagetitle">
                <h2 class="title"><?= $this->renderSection('page_title') ?></h2>
            </div>

            <!-- Main Content -->
            <div class="container large">
                <?= $this->renderSection('content') ?>
            </div>

            <!-- Footer -->
            <footer class="techwave_fn_footer">
                <div class="techwave_fn_footer_content">
                    <div class="copyright">
                        <p>2024© Bitpattern Team</p>
                    </div>
                    <div class="menu_items">
                        <ul>
                            <li><a href="terms.html">Terms of Service</a></li>
                            <li><a href="privacy.html">Privacy Policy</a></li>
                        </ul>
                    </div>
                </div>
            </footer>
        </div>
    </div>

    <!-- Scripts -->
    <script type="text/javascript" src="/ferretodo/js/jquery.js?ver=1.0.0"></script>
    <script type="text/javascript" src="/ferretodo/js/plugins.js?ver=1.0.0"></script>
    <!--[if lt IE 10]> <script type="text/javascript" src="js/ie8.js"></script> <![endif]-->
    <script type="text/javascript" src="/ferretodo/js/init.js?ver=1.0.0"></script>

    <script src="/ferretodo/new/vendor/datatables/js/jquery.dataTables.min.js"></script>
    <script src="/ferretodo/new/js/plugins-init/datatables.init.js"></script>
    
    <!-- Additional Scripts -->
    <?= $this->renderSection('scripts') ?>
</body>
</html>