<?= $this->extend('layouts/mainauth') ?>

<?= $this->section('title') ?>
    Registro de Usuario
<?= $this->endSection() ?>

<?= $this->section('content') ?>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-6">
                <div class="card mt-5">
                    <div class="card-header">
                        <h4 class="text-center">Registro de Usuario</h4>
                    </div>
                    <div class="card-body">
                        <?php if (isset($validation)): ?>
                            <div class="alert alert-danger">
                                <?= $validation->listErrors() ?>
                            </div>
                        <?php endif; ?>
                        
                        <form action="<?= base_url('auth/Aregister') ?>" method="post">
                            <?= csrf_field() ?>
                            
                            <div class="form-group mb-3">
                                <label for="username">Usuario</label>
                                <input type="text" name="username" class="form-control" required>
                            </div>
                            
                            <div class="form-group mb-3">
                                <label for="password">Contraseña</label>
                                <input type="password" name="password" class="form-control" required>
                            </div>
                            
                            <div class="form-group mb-3">
                                <label for="confirm_password">Confirmar Contraseña</label>
                                <input type="password" name="confirm_password" class="form-control" required>
                            </div>

                            <div class="col-md-6">
                                    <div class="form-group mb-3">
                                        <label class="form-label"><strong>Menús Habilitados</strong></label>
                                        <div class="form-check-container" style="max-height: 200px; overflow-y: auto; border: 1px solid #dee2e6; border-radius: 0.375rem; padding: 10px;">
                                            
                                            <div class="form-check mb-2">
                                                <input class="form-check-input" type="checkbox" name="menu_buscador" id="menu_buscador" value="1">
                                                <label class="form-check-label" for="menu_buscador">
                                                    <i class="fas fa-search me-2"></i>Buscador
                                                </label>
                                            </div>
                                            
                                            <div class="form-check mb-2">
                                                <input class="form-check-input" type="checkbox" name="menu_cotizaciones" id="menu_cotizaciones" value="1">
                                                <label class="form-check-label" for="menu_cotizaciones">
                                                    <i class="fas fa-file-invoice-dollar me-2"></i>Cotizaciones
                                                </label>
                                            </div>

                                            <div class="form-check mb-2">
                                                <input class="form-check-input" type="checkbox" name="menu_facturacion" id="menu_facturacion" value="1">
                                                <label class="form-check-label" for="menu_facturacion">
                                                    <i class="fas fa-file-invoice-dollar me-2"></i>Facturación
                                                </label>
                                            </div>
                                            <div class="form-check mb-2">
                                                <input class="form-check-input" type="checkbox" name="menu_despachos" id="menu_despachos" value="1">
                                                <label class="form-check-label" for="menu_despachos">
                                                    <i class="fas fa-file-invoice-dollar me-2"></i>Despachos
                                                </label>
                                            </div>
                                            
                                            <div class="form-check mb-2">
                                                <input class="form-check-input" type="checkbox" name="menu_clientes" id="menu_clientes" value="1">
                                                <label class="form-check-label" for="menu_clientes">
                                                    <i class="fas fa-users me-2"></i>Clientes
                                                </label>
                                            </div>

                                            <div class="form-check mb-2">
                                                <input class="form-check-input" type="checkbox" name="menu_jumpseller" id="menu_jumpseller" value="1">
                                                <label class="form-check-label" for="menu_jumpseller">
                                                    <i class="fas fa-store me-2"></i>Jumpseller
                                                </label>
                                            </div>
                                            
                                            <div class="form-check mb-2">
                                                <input class="form-check-input" type="checkbox" name="menu_mercadolibre" id="menu_mercadolibre" value="1">
                                                <label class="form-check-label" for="menu_mercadolibre">
                                                    <i class="fas fa-store me-2"></i>MercadoLibre
                                                </label>
                                            </div>
                                            
                                            <div class="form-check mb-2">
                                                <input class="form-check-input" type="checkbox" name="menu_ordenes_ml" id="menu_ordenes_ml" value="1">
                                                <label class="form-check-label" for="menu_ordenes_ml">
                                                    <i class="fas fa-shopping-cart me-2"></i>Órdenes MercadoLibre
                                                </label>
                                            </div>
                                            
                                            <div class="form-check mb-2">
                                                <input class="form-check-input" type="checkbox" name="menu_ordenes_venta" id="menu_ordenes_venta" value="1">
                                                <label class="form-check-label" for="menu_ordenes_venta">
                                                    <i class="fas fa-clipboard-list me-2"></i>Órdenes de Venta
                                                </label>
                                            </div>
                                            
                                            <div class="form-check mb-2">
                                                <input class="form-check-input" type="checkbox" name="menu_configuracion" id="menu_configuracion" value="1">
                                                <label class="form-check-label" for="menu_configuracion">
                                                    <i class="fas fa-cog me-2"></i>Configuración
                                                </label>
                                            </div>
                                        </div>
                                        <small class="form-text text-muted">Selecciona los menús que este usuario podrá ver</small>
                                    </div>
                                </div>
                            
                            <div class="d-grid">
                                <button type="submit" class="btn btn-primary">Registrarse</button>
                            </div>
                            
                            <div class="mt-3 text-center">
                                <p>¿Ya tienes una cuenta? <a href="<?= base_url('auth/login') ?>">Iniciar Sesión</a></p>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?= $this->endSection() ?>