<?= $this->extend('layouts/main') ?>

<?= $this->section('content') ?>
<!-- <div class="techwave_fn_user_billing_page"> -->
<!-- <div class="container large"> -->
<!-- <div class="user__billing">
            <div class="billing__info"> -->
<!-- <div class="info__content"> -->
<div class="fn__title_holder">
    <h3>Configuración MercadoLibre</h3>
</div>

<div class="fn__form">
    <div class="fn__form_item">
        <label>Client ID:</label>
        <input type="text" value="<?= esc($ml_config['client_id']['valor'] ?? '') ?>" readonly>
    </div>
    <div class="fn__form_item">
        <label>Estado de Sincronización:</label>
        <div class="toggle_switch">
            <input type="checkbox" id="syncToggle" <?= ($ml_config['sync_active']['valor'] ?? '') ? 'checked' : '' ?>>
            <label for="syncToggle">Activar/Desactivar</label>
        </div>
    </div>
    <button type="button" id="syncNowBtn" class="techwave_fn_button">
        <span>Sincronizar Ahora</span>
    </button>
</div>

<div class="fn__title_holder mt-4">
    <h3>Productos Sincronizados</h3>
</div>
<div class="fn__table_wrap">
    <table id="example" class="display">
        <thead>
            <tr>

                <th>Código</th>
                <th>Bod.</th>
                <th>Ubi.</th>
                <th>Precio</th>
                <th>Descripción</th>
                <th>Stock Actual</th>
                <th>ID MercadoLibre</th>
                <th>Última Sync</th>
                <th>Acciones</th>
                <th><input type="checkbox" id="select-all"></th>
            </tr>
        </thead>
        <tbody id="productosTable">
            <!-- Se llena vía AJAX -->
        </tbody>
    </table>
</div>
<!-- </div> -->
<!-- </div>
        </div> -->
<!-- </div> -->
<!-- </div> -->
<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
function sincronizarProducto(codProd, descrip, mlID) {
    const isChecked = syncToggle.checked;
    console.log('CHECK TOGGLE');
    console.log(isChecked);
    if (isChecked) {
        Swal.fire({
            title: '¿Sincronizar producto?',
            text: `¿Desea sincronizar la publicacion ${mlID}?`,
            icon: 'question',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Sí, sincronizar',
            cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                // Mostrar loading
                Swal.fire({
                    title: 'Sincronizando...',
                    text: 'Por favor espere',
                    allowOutsideClick: false,
                    didOpen: () => {
                        Swal.showLoading();
                    }
                });

                $.ajax({
                    url: '<?= base_url('mercadolibre/sincronizarProducto') ?>',
                    method: 'POST',
                    data: {
                        codProd: codProd,
                        ml_id: mlID
                    },
                    success: function(response) {
                        console.log(response);
                        if (response.success) {
                            if (response.success) {
                                Swal.fire({
                                    title: '¡Éxito!',
                                    text: 'Producto ' + response.data.data.sku + ' MLID ' +
                                        response.data.data.ml_id +
                                        'sincronizado correctamente Stock:' + response.data
                                        .data.new_stock + 'Estado:' + response.data.data
                                        .status,
                                    icon: 'success'
                                });
                                $('#example').DataTable().ajax.reload(null, false);
                            }
                            //     // Recargar solo la fila actual

                        } else {
                            Swal.fire({
                                title: 'Error',
                                text: response.message,
                                icon: 'error'
                            });
                        }
                    },
                    error: function() {
                        Swal.fire({
                            title: 'Error',
                            text: 'Error al sincronizar el producto',
                            icon: 'error'
                        });
                    }
                });
            }
        });

    } else {
        Swal.fire({
            title: 'Error',
            text: 'Activar la casilla de Sincronizacion para activar mercadolibre',
            icon: 'error'
        });

    }

}

function mostrarDetallesML(producto) {
    if (producto.ml_id) {
        Swal.fire({
            title: 'Información de MercadoLibre',
            html: `
                <div class="text-left">
                    <p><strong>Título:</strong> ${producto.ml_title || 'No disponible'}</p>
                    <p><strong>Precio:</strong> ${producto.ml_price || 'No disponible'}</p>
                    <p><strong>Stock ML:</strong> ${producto.ml_quantity || 'No disponible'}</p>
                    <p><strong>Stock Local:</strong> ${producto.Existen || '0'}</p>
                    <p><strong>Estado:</strong> ${producto.ml_status || 'No disponible'}</p>
                    <p><strong>SKU:</strong> ${producto.CodProd || 'No disponible'}</p>
                    <p><strong>ID ML:</strong> ${producto.ml_id || 'No disponible'}</p>
                    ${producto.ml_permalink ?
                        `<a href="${producto.ml_permalink}" target="_blank" class="text-blue-500 hover:underline">
                            Ver en MercadoLibre
                         </a>` : ''
                    }
                </div>
            `,
            width: '600px',
            customClass: {
                container: 'text-left'
            }
        });
    } else {
        Swal.fire({
            icon: 'error',
            title: 'Producto no encontrado',
            text: 'No se encontró información en MercadoLibre para este producto'
        });
    }
}
document.addEventListener('DOMContentLoaded', function() {
    const syncToggle = document.getElementById('syncToggle');
    const syncNowBtn = document.getElementById('syncNowBtn');

    // $('#ml-selector').on('change', function (e) {
    //     e.preventDefault();
    //     const mlId = $(this).val();
    //     const selected = $(this).is(':checked') ? 1 : 0;

    //     console.log('ML ID:', mlId);
    //     console.log('Selected:', selected);

    //     $.ajax({
    //         url: '<?= base_url('mercadolibre/toggleProductSelection') ?>',
    //         method: 'POST',
    //         data: {
    //             ml_id: mlId,
    //             selected: selected
    //         },
    //         success: function (response) {
    //             if (response.success) {
    //                 console.log('Selección actualizada correctamente');
    //             } else {
    //                 console.error('Error al actualizar selección:', response.message);
    //                 // Revertir el checkbox si hubo error
    //                 $(e.target).prop('checked', !selected);
    //             }
    //         },
    //         error: function (xhr, status, error) {
    //             console.error('Error en la petición:', error);
    //             // Revertir el checkbox si hubo error
    //             $(e.target).prop('checked', !selected);
    //         }
    //     });
    // });

    // document.getElementById('ml-selector').onclick = function (e) {
    //     e.preventDefault();
    //     const mlId = $(this).val();
    //     const selected = $(this).is(':checked') ? 1 : 0;

    //     console.log('ML ID:', mlId);
    //     console.log('Selected:', selected);

    //     $.ajax({
    //         url: '<?= base_url('mercadolibre/toggleProductSelection') ?>',
    //         method: 'POST',
    //         data: {
    //             ml_id: mlId,
    //             selected: selected
    //         },
    //         success: function (response) {
    //             if (response.success) {
    //                 console.log('Selección actualizada correctamente');
    //             } else {
    //                 console.error('Error al actualizar selección:', response.message);
    //                 // Revertir el checkbox si hubo error
    //                 $(e.target).prop('checked', !selected);
    //             }
    //         },
    //         error: function (xhr, status, error) {
    //             console.error('Error en la petición:', error);
    //             // Revertir el checkbox si hubo error
    //             $(e.target).prop('checked', !selected);
    //         }
    //     });
    // };
    $('#select-all').on('change', function() {
        const isChecked = $(this).is(':checked');
        console.log('Selected:', isChecked);
        $('.ml-selector').prop('checked', isChecked);

        // Actualizar todos los elementos
        $('.ml-selector').each(function() {
            const mlId = $(this).val();
            $.ajax({
                url: '<?= base_url('mercadolibre/toggleProductSelection') ?>',
                method: 'POST',
                data: {
                    ml_id: mlId,
                    selected: isChecked ? 1 : 0
                }
            });
        });
    });

    if ($.fn.DataTable.isDataTable('#example')) {
        $('#example').DataTable().destroy();
    }

    const table = $('#example').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: '<?= base_url('mercadolibre/productos') ?>',
            type: 'GET'
        },
        columns: [{
                data: 'CodProd'
            },
            {
                data: 'CodUbic'
            },
            {
                data: 'Ubic'
            },
            {
                data: 'PrecioIVA'
            },
            {
                data: 'Descrip'
            },
            {
                data: 'Existen'
            },
            {
                data: 'ml_id'
            },
            {
                data: 'ultimo_sync'
            },
            {
                data: null,
                name: 'Acciones',
                orderable: false,
                render: function(data, type, row) {
                    return `
                    <div class="flex gap-2">
                        <button onclick="sincronizarProducto('${row.CodProd}', '${row.Descrip}', '${row.ml_id}')" 
                                class="techwave_fn_button small">
                            <span>Sincronizar</span>
                        </button>
                        <button onclick="mostrarDetallesML(${JSON.stringify(row).replace(/"/g, '&quot;')})"
                            class="techwave_fn_button small">
                            <i class="lucide-info"></i>
                        </button>
                    </div>`;
                }
            },
            {
                data: null,
                orderable: false,
                className: 'text-center',
                render: function(data, type, row) {
                    return `<input type="checkbox" class="ml-selector" id="ml-selector" name="selected_orders[]" 
                        value="${row.ml_id}" ${row.selected == 1 ? 'checked' : ''}>`;
                }
            }
        ],
        pageLength: 25,
        language: {
            url: 'https://cdn.datatables.net/plug-ins/1.13.7/i18n/es-ES.json'
        },
        initComplete: function() {
            $(document).on('change', '.ml-selector', function(e) {
                e.preventDefault();
                const mlId = $(this).val();
                const selected = $(this).is(':checked') ? 1 : 0;

                console.log('ML ID:', mlId);
                console.log('Selected:', selected);

                $.ajax({
                    url: '<?= base_url('mercadolibre/toggleProductSelection') ?>',
                    method: 'POST',
                    data: {
                        ml_id: mlId,
                        selected: selected
                    },
                    success: function(response) {
                        if (response.success) {
                            console.log('Selección actualizada correctamente');
                        } else {
                            console.error('Error al actualizar selección:',
                                response.message);
                            // Revertir el checkbox si hubo error
                            $(e.target).prop('checked', !selected);
                        }
                    },
                    error: function(xhr, status, error) {
                        console.error('Error en la petición:', error);
                        // Revertir el checkbox si hubo error
                        $(e.target).prop('checked', !selected);
                    }
                });
            });
            // Aquí puedes agregar cualquier configuración adicional
            // después de que la tabla se haya inicializado
        }
    });
    //var tablev = $('#example').DataTable();

    // Toggle sincronización
    syncToggle.addEventListener('change', function() {
        $.ajax({
            url: '<?= base_url('mercadolibre/toggleSync') ?>',
            method: 'POST',
            data: {
                estado: this.checked ? 1 : 0
            },
            success: function(response) {
                if (response.success) {
                    alert('Estado de sincronización actualizado');
                }
            }
        });
    });

    // Función para obtener productos seleccionados
    function getSelectedProducts() {
        const checkboxes = document.getElementsByName('selected_orders[]');
        return Array.from(checkboxes)
            .filter(cb => cb.checked)
            .map(cb => cb.value);
    }
    // Función de sincronización
    function sincronizarProductos(productos = []) {
        if (!syncToggle.checked) {
            Swal.fire({
                title: 'Error',
                text: 'Activar la casilla de Sincronización para activar mercadolibre',
                icon: 'error'
            });
            return;
        }

        Swal.fire({
            title: 'Sincronizando...' + productos.toString(),
            text: 'Por favor espere',
            allowOutsideClick: false,
            didOpen: () => {
                Swal.showLoading();
            }
        });

        $.ajax({
            url: '<?= base_url('mercadolibre/sincronizar') ?>',
            method: 'POST',
            data: {
                productos: productos
            },
            success: function(response) {
                if (response.success) {
                    Swal.fire({
                        title: '¡Éxito!',
                        text: 'Productos sincronizados correctamente',
                        icon: 'success'
                    });
                    $('#example').DataTable().ajax.reload(null, false);
                } else {
                    Swal.fire({
                        title: 'Error',
                        text: response.message,
                        icon: 'error'
                    });
                }
            },
            error: function() {
                Swal.fire({
                    title: 'Error',
                    text: 'Error al sincronizar los productos',
                    icon: 'error'
                });
            }
        });
    }

    syncNowBtn.addEventListener('click', function() {
        const selectedProducts = getSelectedProducts();
        sincronizarProductos(selectedProducts);
    });

    // Sincronizar ahora
    // syncNowBtn.addEventListener('click', function () {
    //     if (syncToggle.checked) {
    //         if (!confirm('¿Desea sincronizar los productos ahora?')) return;

    //         $.ajax({
    //             url: '<?= base_url('mercadolibre/sincronizar') ?>',
    //             method: 'POST',
    //             success: function (response) {
    //                 alert(response.message);
    //                 if (response.success) {
    //                     cargarProductos();
    //                 }
    //             }
    //         });

    //     } else {

    //         Swal.fire({
    //             title: 'Error',
    //             text: 'Activar la casilla de Sincronizacion para activar mercadolibre',
    //             icon: 'error'
    //         });

    //     }

    // });



    function cargarProductos() {
        $.ajax({
            url: '<?= base_url('mercadolibre/productos') ?>',
            method: 'GET',
            success: function(response) {
                console.log(response);
                const tbody = document.getElementById('productosTable');
                tbody.innerHTML = '';

                response.forEach(producto => {
                    tbody.innerHTML += `
                        <tr>
                            <td>${producto.cod_prod}</td>
                            <td>${producto.Descrip}</td>
                            <td>${producto.Existen}</td>
                            <td>${producto.ml_id}</td>
                            <td>${producto.ultimo_sync}</td>
                        </tr>
                    `;
                });
            }
        });
    }


    // Cargar productos al iniciar
    //cargarProductos();
});
</script>
<?= $this->endSection() ?>