<?= $this->extend('layouts/main') ?>

<?= $this->section('title') ?>
Listado de despachos
<?= $this->endSection() ?>

<?= $this->section('page_title') ?>
Listado de despachos
<?= $this->endSection() ?>

<?= $this->section('content') ?>
<div class="techwave_fn_user_billing_page">
    <div class="container small">
        <div class="fn__title_holder">
            <h3>Listado de Despachos</h3>
        </div>
        
        <div class="fn__table_wrap">
            <table id="example" class="display">
                <thead>
                    <tr>
                        <th>Orden ID</th>
                        <th>Fecha</th>
                        <th>Punto de Venta</th>
                        <th>N° Productos</th>
                        <th>Acciones</th>
                    </tr>
                </thead>
                <tbody id="ordenesTable">
                    <!-- Se llena vía AJAX -->
                </tbody>
            </table>
        </div>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    if ($.fn.DataTable.isDataTable('#example')) {
        $('#example').DataTable().destroy();
    }

    // const table = $('#example').DataTable({
    //     processing: true,
    //     serverSide: true,
    //     ajax: {
    //         url: '<?= base_url('ordenes/listar') ?>',
    //         type: 'GET'
    //     },
    //     columns: [
    //         { data: 'NumeroD' },
    //         { data: 'FechaT' },
    //         { data: 'CodUsua' },
    //         { data: 'total_productos' },
    //         { data: 'CodSucu' }
    //     ],
    //     pageLength: 25,
    //     language: {
    //         url: '//cdn.datatables.net/plug-ins/1.13.7/i18n/es-ES.json'
    //     },
    //     initComplete: function() {
    //         // Aquí puedes agregar cualquier configuración adicional
    //         // después de que la tabla se haya inicializado
    //     }
    // });
    const table = $('#example').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: '<?= base_url('despachos/listar') ?>',
            type: 'GET'
        },
        columns: [
            { 
                data: 'NumeroD',
                title: 'Orden ID'
            },
            { 
                data: 'FechaT',
                title: 'Fecha',
                render: function(data, type, row) {
                    if (type === 'display') {
                        let fecha = new Date(data);
                        return fecha.toLocaleDateString('es-ES', {
                            day: '2-digit',
                            month: '2-digit',
                            year: 'numeric',
                            hour: '2-digit',
                            minute: '2-digit'
                        });
                    }
                    return data;
                }
            },
            { 
                data: 'CodUsua',
                title: 'Punto de Venta'
            },
            { 
                data: 'total_productos',
                title: 'N° Productos',
                className: 'text-center'
            },
            { 
                data: 'NumeroD',
                title: 'Acciones',
                orderable: false,
                render: function(data, type, row) {
                    return `<a href="<?= base_url('despachos/detalle') ?>/${data}" 
                              target="_blank"
                              class="techwave_fn_button small">
                              <span>Ver Detalle</span>
                           </a>`;
                }
            }
        ],
        order: [[1, 'desc']], // Ordenar por fecha descendente por defecto
        pageLength: 25,
        language: {
            url: 'https://cdn.datatables.net/plug-ins/1.13.7/i18n/es-ES.json'
        },
        dom: '<"top"Bf>rt<"bottom"lip>',
        buttons: [
            {
                extend: 'excel',
                text: 'Exportar a Excel',
                className: 'techwave_fn_button small',
                exportOptions: {
                    columns: [0, 1, 2, 3]
                }
            }
        ],
        responsive: true,
        initComplete: function(settings, json) {
            // Añadir clases personalizadas a los elementos de la tabla
            //$('.dataTables_wrapper .dataTables_length select').addClass('techwave_fn_input');
            //-?groupEnd$('.dataTables_wrapper .dataTables_filter input').addClass('techwave_fn_input');
        }
    });
    //cargarOrdenes();
});

function cargarOrdenes() {
    $.ajax({
        url: '<?= base_url('despachos/listar') ?>',
        method: 'GET',
        success: function(response) {
            const tbody = document.getElementById('ordenesTable');
            tbody.innerHTML = '';
            
            response.forEach(orden => {
                tbody.innerHTML += `
                    <tr>
                        <td>${orden.NumeroD}</td>
                        <td>${formatDate(orden.FechaT)}</td>
                        <td>${orden.CodUsuario}</td>
                        <td>${orden.total_productos}</td>
                        <td>
                            <a href="<?= base_url('despachos/detalle') ?>/${orden.NumeroD}" 
                               target="_blank"
                               class="techwave_fn_button small">
                                <span>Ver Detalle</span>
                            </a>
                        </td>
                    </tr>
                `;
            });
        }
    });
}

function formatDate(dateString) {
    const date = new Date(dateString);
    return date.toLocaleDateString('es-ES', {
        year: 'numeric',
        month: '2-digit',
        day: '2-digit',
        hour: '2-digit',
        minute: '2-digit'
    });
}
</script>
<?= $this->endSection() ?>