<?= $this->extend('layouts/mainauth') ?>

<?= $this->section('title') ?>
    Iniciar Sesión
<?= $this->endSection() ?>

<?= $this->section('content') ?>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-6">
                <div class="card mt-5">
                    <div class="card-header">
                        <h4 class="text-center">Iniciar Sesión</h4>
                    </div>
                    <div class="card-body">
                        <?php if (session()->getFlashdata('msg')): ?>
                            <div class="alert alert-danger"><?= session()->getFlashdata('msg') ?></div>
                        <?php endif; ?>
                        
                        <form action="<?= base_url('auth/Alogin') ?>" method="post">
                            <?= csrf_field() ?>
                            
                            <div class="form-group mb-3">
                                <label for="username">Usuario</label>
                                <input type="text" name="username" class="form-control" required>
                            </div>
                            
                            <div class="form-group mb-3">
                                <label for="password">Contraseña</label>
                                <input type="password" name="password" class="form-control" required>
                            </div>
                            
                            <div class="d-grid">
                                <button type="submit" class="btn btn-primary">Iniciar Sesión</button>
                            </div>
                            
                            <!-- <div class="mt-3 text-center">
                                <p>¿No tienes una cuenta? <a href="<?= base_url('auth/register') ?>">Regístrate</a></p>
                            </div> -->
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?= $this->endSection() ?>