<?= $this->extend('layouts/main') ?>

<?= $this->section('title') ?>
Gestión de Cotizaciones
<?= $this->endSection() ?>

<?= $this->section('page_title') ?>
GESTIÓN DE COTIZACIONES
<?= $this->endSection() ?>

<?= $this->section('content') ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Nueva Cotización</h4>
                    <div>
                            <a href="<?= base_url('cotizaciones/listado') ?>" class="btn btn-danger" target="_blank">
                                <i class="fas fa-file-pdf"></i> Listar Cotizaciones
                            </a>
                        </div>
                </div>
                <div class="card-body">
                    <form id="cotizacionForm">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="cliente_id" class="form-label">Cliente</label>
                                    <div class="input-group">
                                        <input type="text" class="form-control" id="buscar_cliente" placeholder="Buscar cliente...">
                                        <input type="hidden" id="cliente_id" name="cliente_id" required>
                                        <button class="btn btn-outline-secondary" type="button" data-bs-toggle="modal" data-bs-target="#clientesModal">
                                            <i class="fas fa-search"></i>
                                        </button>
                                    </div>
                                    <div id="cliente_seleccionado" class="form-text"></div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="fecha" class="form-label">Fecha</label>
                                    <input type="date" class="form-control" id="fecha" name="fecha" value="<?= date('Y-m-d') ?>" readonly>
                                </div>
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label for="notas" class="form-label">Notas</label>
                            <textarea class="form-control" id="notas" name="notas" rows="2"></textarea>
                        </div>
                        
                        <div class="mb-3">
                            <div class="d-flex justify-content-between">
                                <h5>Productos</h5>
                                <button type="button" class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#productosModal">
                                    <i class="fas fa-plus"></i> Agregar Producto
                                </button>
                            </div>
                            
                            <div class="table-responsive mt-3">
                                <table class="table table-bordered table-striped" id="tablaProductos">
                                    <thead>
                                        <tr>
                                            <th>SKU</th>
                                            <th>Descripción</th>
                                            <th>Cantidad</th>
                                            <th>Precio Unit.</th>
                                            <th>Subtotal</th>
                                            <th>IVA (19%)</th>
                                            <th>Total</th>
                                            <th>Acciones</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <!-- Los productos se agregarán con JavaScript -->
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <td colspan="4" class="text-end"><strong>Totales:</strong></td>
                                            <td id="total_subtotal">0.00</td>
                                            <td id="total_iva">0.00</td>
                                            <td id="total_final">0.00</td>
                                            <td></td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                        
                        <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                            <button type="button" class="btn btn-secondary" id="btnCancelar">Cancelar</button>
                            <button type="submit" class="btn btn-primary" id="btnGuardar">Guardar Cotización</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal de Productos -->
<div class="modal fade" id="productosModal" tabindex="-1" aria-labelledby="productosModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="productosModalLabel">Buscar Producto</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <input type="text" class="form-control" id="buscarProductoInput" placeholder="Buscar por código, descripción o SKU...">
                </div>
                <div class="table-responsive">
                    <table class="table table-bordered table-striped" id="tablaProductosBusqueda">
                        <thead>
                            <tr>
                                <th>Código</th>
                                <th>Descripción</th>
                                <th>SKU</th>
                                <th>Precio</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($productos as $producto): ?>
                            <tr>
                                <td><?= $producto['CodProd'] ?></td>
                                <td><?= $producto['Descrip'] ?></td>
                                <td><?= $producto['Descrip2'] ?></td>
                                <td><?= number_format($producto['Precio1'], 2) ?></td>
                                <td>
                                    <button type="button" class="btn btn-sm btn-primary btnSeleccionarProducto" 
                                        data-codigo="<?= $producto['CodProd'] ?>" 
                                        data-nombre="<?= $producto['Descrip'] ?>" 
                                        data-sku="<?= $producto['Descrip2'] ?>" 
                                        data-precio="<?= $producto['Precio1'] ?>">
                                        Seleccionar
                                    </button>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal de Clientes -->
<div class="modal fade" id="clientesModal" tabindex="-1" aria-labelledby="clientesModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="clientesModalLabel">Buscar Cliente</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <input type="text" class="form-control" id="buscarClienteInput" placeholder="Buscar por código, nombre o ID...">
                </div>
                <div class="table-responsive">
                    <table class="table table-bordered table-striped" id="tablaClientesBusqueda">
                        <thead>
                            <tr>
                                <th>Código</th>
                                <th>Nombre</th>
                                <th>Identificación</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($clientes as $cliente): ?>
                            <tr>
                                <td><?= $cliente['CodClie'] ?></td>
                                <td><?= $cliente['Descrip'] ?></td>
                                <td><?= $cliente['ID3'] ?></td>
                                <td>
                                    <button type="button" class="btn btn-sm btn-primary btnSeleccionarCliente" 
                                        data-codigo="<?= $cliente['CodClie'] ?>" 
                                        data-nombre="<?= $cliente['Descrip'] ?>" 
                                        data-id="<?= $cliente['ID3'] ?>">
                                        Seleccionar
                                    </button>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
    $(document).ready(function() {
        // Inicializar DataTables
        $('#tablaProductosBusqueda').DataTable({
            "language": {
                "url": "https://cdn.datatables.net/plug-ins/1.10.25/i18n/Spanish.json"
            }
        });
        
        $('#tablaClientesBusqueda').DataTable({
            "language": {
                "url": "https://cdn.datatables.net/plug-ins/1.10.25/i18n/Spanish.json"
            }
        });
        
        // Variables para almacenar los items de la cotización
        let items = [];
        
        // Seleccionar un producto
        $(document).on('click', '.btnSeleccionarProducto', function() {
            const codigo = $(this).data('codigo');
            const nombre = $(this).data('nombre');
            const sku = $(this).data('sku');
            const precio = parseFloat($(this).data('precio'));
            
            // Solicitar la cantidad
            const cantidad = prompt('Ingrese la cantidad:', '1');
            if (cantidad !== null && !isNaN(cantidad) && parseFloat(cantidad) > 0) {
                agregarProducto({
                    codigo: codigo,
                    nombre: nombre,
                    sku: sku,
                    cantidad: parseFloat(cantidad),
                    precio: precio
                });
                
                // Cerrar el modal
                $('#productosModal').modal('hide');
            }
        });
        
        // Seleccionar un cliente
        $(document).on('click', '.btnSeleccionarCliente', function() {
            const codigo = $(this).data('codigo');
            const nombre = $(this).data('nombre');
            const id = $(this).data('id');
            
            $('#cliente_id').val(codigo);
            $('#cliente_seleccionado').html(`<strong>${nombre}</strong> (${id})`);
            
            // Cerrar el modal
            $('#clientesModal').modal('hide');
        });
        
        // Agregar producto a la tabla
        function agregarProducto(producto) {
            // Verificar si el producto ya existe
            const existeIndex = items.findIndex(item => item.sku === producto.sku);
            if (existeIndex >= 0) {
                // Actualizar cantidad
                items[existeIndex].cantidad += producto.cantidad;
                actualizarTablaProductos();
                return;
            }
            
            const subtotal = producto.cantidad * producto.precio;
            const iva = subtotal * 0.19; // 19% IVA
            const total = subtotal + iva;
            
            // Agregar a la lista de items
            items.push({
                codigo: producto.codigo,
                nombre: producto.nombre,
                sku: producto.sku,
                cantidad: producto.cantidad,
                precio: producto.precio,
                subtotal: subtotal,
                iva: iva,
                total: total
            });
            
            actualizarTablaProductos();
        }
        
        // Actualizar la tabla de productos
        function actualizarTablaProductos() {
            let html = '';
            let totalSubtotal = 0;
            let totalIva = 0;
            let totalFinal = 0;
            
            items.forEach((item, index) => {
                // Recalcular totales
                const subtotal = item.cantidad * item.precio;
                const iva = subtotal * 0.19;
                const total = subtotal + iva;
                
                // Actualizar item
                items[index].subtotal = subtotal;
                items[index].iva = iva;
                items[index].total = total;
                
                // Sumar a los totales
                totalSubtotal += subtotal;
                totalIva += iva;
                totalFinal += total;
                
                html += `
                <tr>
                    <td>${item.sku}</td>
                    <td>${item.nombre}</td>
                    <td>${item.cantidad}</td>
                    <td>${item.precio.toFixed(2)}</td>
                    <td>${subtotal.toFixed(2)}</td>
                    <td>${iva.toFixed(2)}</td>
                    <td>${total.toFixed(2)}</td>
                    <td>
                        <button type="button" class="btn btn-sm btn-danger btnEliminarProducto" data-index="${index}">
                            <i class="fas fa-trash"></i>
                        </button>
                        <button type="button" class="btn btn-sm btn-warning btnEditarProducto" data-index="${index}">
                            <i class="fas fa-edit"></i>
                        </button>
                    </td>
                </tr>
                `;
            });
            
            $('#tablaProductos tbody').html(html);
            $('#total_subtotal').text(totalSubtotal.toFixed(2));
            $('#total_iva').text(totalIva.toFixed(2));
            $('#total_final').text(totalFinal.toFixed(2));
        }
        
        // Eliminar producto
        $(document).on('click', '.btnEliminarProducto', function() {
            const index = $(this).data('index');
            if (confirm('¿Está seguro de eliminar este producto?')) {
                items.splice(index, 1);
                actualizarTablaProductos();
            }
        });
        
        // Editar producto
        $(document).on('click', '.btnEditarProducto', function() {
            const index = $(this).data('index');
            const item = items[index];
            
            const nuevaCantidad = prompt('Ingrese la nueva cantidad:', item.cantidad);
            if (nuevaCantidad !== null && !isNaN(nuevaCantidad) && parseFloat(nuevaCantidad) > 0) {
                const nuevoPrecio = prompt('Ingrese el nuevo precio:', item.precio);
                if (nuevoPrecio !== null && !isNaN(nuevoPrecio) && parseFloat(nuevoPrecio) > 0) {
                    items[index].cantidad = parseFloat(nuevaCantidad);
                    items[index].precio = parseFloat(nuevoPrecio);
                    actualizarTablaProductos();
                }
            }
        });
        
        // Buscar productos en tiempo real
        $('#buscarProductoInput').on('keyup', function() {
            const term = $(this).val().toLowerCase();
            $('#tablaProductosBusqueda tbody tr').filter(function() {
                $(this).toggle($(this).text().toLowerCase().indexOf(term) > -1);
            });
        });
        
        // Buscar clientes en tiempo real
        $('#buscarClienteInput').on('keyup', function() {
            const term = $(this).val().toLowerCase();
            $('#tablaClientesBusqueda tbody tr').filter(function() {
                $(this).toggle($(this).text().toLowerCase().indexOf(term) > -1);
            });
        });
        
        // Guardar cotización
        $('#cotizacionForm').on('submit', function(e) {
            e.preventDefault();
            
            if (!$('#cliente_id').val()) {
                alert('Debe seleccionar un cliente');
                return;
            }
            
            if (items.length === 0) {
                alert('Debe agregar al menos un producto');
                return;
            }
            
            // Calcular totales finales
            const subtotal = parseFloat($('#total_subtotal').text());
            const impuesto = parseFloat($('#total_iva').text());
            const total = parseFloat($('#total_final').text());
            
            // Preparar datos para enviar
            const formData = {
                cliente_id: $('#cliente_id').val(),
                notas: $('#notas').val(),
                items: JSON.stringify(items),
                subtotal: subtotal,
                impuesto: impuesto,
                total: total
            };
            
            // Enviar datos al servidor
            $.ajax({
                url: '<?= base_url('cotizaciones/crear') ?>',
                type: 'POST',
                data: formData,
                dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        alert(response.message);
                        // Limpiar formulario
                        $('#cliente_id').val('');
                        $('#cliente_seleccionado').html('');
                        $('#notas').val('');
                        items = [];
                        actualizarTablaProductos();
                    } else {
                        alert('Error: ' + response.message);
                    }
                },
                error: function() {
                    alert('Error en la solicitud');
                }
            });
        });
        
        // Cancelar cotización
        $('#btnCancelar').on('click', function() {
            if (confirm('¿Está seguro de cancelar la cotización?')) {
                // Limpiar formulario
                $('#cliente_id').val('');
                $('#cliente_seleccionado').html('');
                $('#notas').val('');
                items = [];
                actualizarTablaProductos();
            }
        });
    });
</script>
<?= $this->endSection() ?>