<?php

namespace App\Controllers;

class Despachos extends BaseController
{
    protected $configModel;
    protected $mlModel;
    protected $ordenesModel;

    public function __construct()
    {
        $this->configModel = new \App\Models\ConfigModel();
        $this->mlModel = new \App\Models\MercadoLibreModel();
        $this->ordenesModel = new \App\Models\OrdenesModel();
    }

    public function index()
    {
        $data['ml_config'] = [
            'client_id' => $this->configModel->getConfig('ml_client_id'),
            'client_secret' => $this->configModel->getConfig('ml_client_secret'),
            'sync_active' => $this->configModel->getConfig('ml_sync_active')
        ];

        return view('home_despachos', $data);
    }
    public function completarDespacho()
    {
        $json = $this->request->getJSON();
        $db = \Config\Database::connect();

        try {
            $db->table('SAFACT')
                ->where('NumeroD', $json->orderId)
                ->update(['Notas10' => 'DESPACHADO']);

            return $this->response->setJSON(['success' => true]);
        } catch (\Exception $e) {
            return $this->response->setStatusCode(500)
                ->setJSON(['error' => $e->getMessage()]);
        }
    }

    public function actualizarProducto()
    {
        $json = $this->request->getJSON();
        $db = \Config\Database::connect();

        try {
            // $db->table('SAITEMFAC')
            //     ->where('NumeroD', $json->orderId)
            //     ->where('CodItem', $json->barcode)
            //     ->update(['Descrip10' => $json->status]);

             // Obtener cantidad actual escaneada
            $item = $db->table('SAITEMFAC')
                ->where('NumeroD', $json->orderId)
                //->where('CodItem', $json->barcode)
                ->where('Refere', $json->barcode)
                ->get()->getRowArray();

            $cantidadEscaneada = ($item['Descrip9'] ?? 0) + 1;
            
            // Actualizar cantidad escaneada y estado si es necesario
            $updateData = ['Descrip9' => $cantidadEscaneada];
            
            if ($cantidadEscaneada >= $item['Cantidad']) {
                $updateData['Descrip10'] = 'VERIFICADO';
            }
            else{
                $updateData['Descrip10'] = 'PENDIENTE';
            }

            $db->table('SAITEMFAC')
                ->where('NumeroD', $json->orderId)
                ->where('Refere', $json->barcode)
                ->update($updateData);

            #return $this->response->setJSON(['success' => true]);
            return $this->response->setJSON([
                'success' => true,
                'scannedCount' => $cantidadEscaneada,
                'status' => $updateData['Descrip10'] ?? $item['Descrip10']
            ]);
        } catch (\Exception $e) {
            return $this->response->setStatusCode(500)
                ->setJSON(['error' => $e->getMessage()]);
        }
    }
    public function listar()
    {
        //$ordenes = $this->ordenesModel->getOrdenes();
        //return $this->response->setJSON($ordenes);

        if ($this->request->isAJAX()) {
            $start = $this->request->getGet('start') ?? 0;
            $length = $this->request->getGet('length') ?? 10;
            $search = $this->request->getGet('search')['value'] ?? '';
            $order = $this->request->getGet('order')[0] ?? null;
            $columns = ['NumeroD', 'FechaT', 'CodUsua', 'total_productos', 'CodSucu'];
            $orderColumn = $columns[$order['column'] ?? 0] ?? 'FechaT';
            $orderDir = $order['dir'] ?? 'DESC';
    
            $result = $this->ordenesModel->getOrdenes(
                $start, 
                $length, 
                $search,
                $orderColumn,
                $orderDir
            );
    
            return $this->response->setJSON([
                'draw' => $this->request->getGet('draw'),
                'recordsTotal' => $result['recordsTotal'],
                'recordsFiltered' => $result['recordsFiltered'],
                'data' => $result['data']
            ]);
        }
    }

    public function detalle($numeroD)
    {
        $data = $this->ordenesModel->getDetalleOrden($numeroD);
        return view('despachos/detalle', $data);
    }

   
}